#ifndef GLOBAL_H_
#define GLOBAL_H_

#include "mbed.h"
#include "JSN_SR04.h"
#include "AS5045.h"
#include "E18_D80NK.h"
#include <RS485.h>
#include "DS1820.h"
#include "Watchdog.h"

#define MAX_SENSOSRS   32 
 
#define BLINKING_RATE     5000

#define TEST_WATCHDOG   0
#define TEST_REQUEST    0 
#define MAIN_CODE       1

// rs-485 pins
#define UART1_TX    PB_6
#define UART1_RX    PB_7
#define DE_TXD_1    PB_5

#define UART2_TX    PA_2
#define UART2_RX    PA_3
#define DE_TXD_2    PB_3

// adc pins 
#define ADC1_IN0    PA_0
#define ADC1_IN1    PA_1

#define ADC1_IN8    PB_0
#define ADC1_IN9    PB_1

// Encoder spi chip select pins
#define SP1_NSS1    PA_4
#define SP1_NSS2    PB_2

// ultra sonics pins 

#define TIM1_CH2        PA_9 // echo pin 
#define TRIG_PA8_OUT    PA_8
#define TRIG_PB15_OUT   PB_15
#define TRIG_PB14_OUT   PB_14

//ir obstacle pins
#define IR1_PB12_OUT   PB_12
#define IR2_PB13_OUT   PB_13

DS1820* ds1820[MAX_SENSOSRS];

#define DEBUG_LED   PC_13

#endif /* GLOBAL_H_ */