#ifndef RS485_H
#define RS485_H
 
#include "BufferedSerial.h"
#include "mbed.h"

class RS485 : public BufferedSerial
{
private:
    typedef unsigned int word;
    typedef uint8_t byte;
    typedef uint8_t boolean;
    typedef void (*voidFuncPtr)(void);
    
public:
    /** Create a BufferedSerial port, connected to the specified transmit and receive pins
     *  @param tx Transmit pin
     *  @param rx Receive pin
     *  @param dere Enable pin, this pin should be connected to !RE and DE
     *  @note uses BufferedSerial
     */
    RS485(PinName tx, PinName rx, PinName dere);
 
    /** calculate 8-bit CRC
    *  cyclic redundancy check
    *  @param addr byte pointer of information to use (typical an byte array)
    *  @param len length of byte of information were converting
    *  @return the CRC byte
    */
    static byte crc8 (const byte *addr, byte len);
    
    /** sendComplemented byte
    *  send a byte complemented, repeated
    *       only values sent would be (in hex):
    *       0F, 1E, 2D, 3C, 4B, 5A, 69, 78, 87, 96, A5, B4, C3, D2, E1, F0
    *  @what the byte to complement
    */
    void sendComplemented (const byte what);
    
    /** send message
    *  cyclic redundancy check
    *  @param data the data to be sent through RS485
    *  @param length length of the data 
    *  @note puts STX at start, ETX at end, and add CRC
    */   
    void sendMsg (const byte * data, const byte length);
    
    /** receive message
    *  reads serial port and populates data
    *  @param data buffer to receive into
    *  @param length length of the data 
    *  @param timeout clock_mseconds before timing out
    *  @return the number of bytes received
    *  
    */
    byte recvMsg (byte * data, const byte length, unsigned long timeout);
      
 
};
#endif