#ifndef AS5045_H
#define AS5045_H

#include "mbed.h"

// Class which implements AS5045 encoder interface
class AS5045
{
public:
  AS5045(PinName cs);								// Constructor

  int getPosition();									// Read tick amount from encoder (position)
  float getAngle();								// Convert position of the encoder to degrees

private:
  SPI _spi;												// MBED SPI instance
  DigitalOut _cs;
  uint16_t EncoderByteData;										// MBED digital output pin

  static const float MAX_VALUE = 1024;			// Maximum possible encoder position value (ticks for full rotation)
  static const float RESOLUTION = 0.3515625;	// Encoder resolution (0.08789 degrees per tick)
  static const float SPI_FREQ = 5000;		// Frequency of the SPI bus
};

#endif	// AS5045_H
