#include "AS5045.h"
//we have 5040
/** Constructor
 *
 *	@param CS Pin number for the digital output
 *
 *	@note
 *		PinName CS is the digital output pin number
 */


Timer timer_enc;
AS5045::AS5045(PinName CS) :
    _spi(NC,D12, D13),	// MBED SPI init
    _cs(CS)				// Digital output pin init
{
    // Set SPI bitwidth
    _spi.format(8, 1);

    // Set SPI frequency
    _spi.frequency(SPI_FREQ);//SPI_FREQ);
    // Set the digital output high
    _cs = 1;
}

/** Read tick amount from encoder (position)
 *
 *	@note
 *		Tick amount is recieved through SPI
 */
int AS5045::getPosition()
{
    unsigned int upper,		// Upper part of the tick amount integer
             lower;		// Lower part of the tick amount integer
//
//    // Set the chip select pin low
//    //timer_enc.reset();
//    timer_enc.start();
//    _cs = 0;
//    
//    wait_ms(1);
//    // Read data from the encoder
//    upper = (_spi.write(0x00)) ;
//// 	lower = (_spi.write(0x00));
//
//// 	lower = lower >> 6;
////    upper = (upper >> 6)+lower;
////   upper = upper & 0xffc0;
////    upper = upper >> 6;
//
//    // Set the chip select pin high
//    _cs = 1;
//    //wait_ms(5);
    // Return full 9-bits tick amount
   // return (upper>>5);
    //return upper ;
    
    _cs = 0;
   upper = _spi.write(0x00);
   lower = _spi.write(0x00);
  _cs = 1;
 
 
 	//upper &=~ 0xF0;//mask out the first 4 bits
//     EncoderByteData  = upper << 8; //shift MSB to correct EncoderByteData in EncoderByteData message
//     EncoderByteData  += lower; // add LSB to EncoderByteData message to complete message
  return ((upper << 2)|(lower >> 6));
  //return EncoderByteData; 
}

/** Convert position of the encoder to degrees
 *
 *	@note
 *		Tick amount is recieved internally
 */
float AS5045::getAngle()
{
    // Get data from the encoder
    float value = (float)getPosition();

    // Return degrees of rotation of the encoder
    return value * RESOLUTION;
}
