#ifndef JSN_SR04_H_
#define JSN_SR04_H_

class JSN_SR04 {

    public:

    /** Receives two PinName variables.
     * @param echoPin mbed pin to which the echo signal is connected to
     * @param triggerPin mbed pin to which the trigger signal is connected to
     */
    JSN_SR04(PinName echoPin, PinName triggerPin);

    /** Start the measurement. Measurement time depends on the distance.
     *  Maximum measurement time is limited to 25 ms (400 cm).
     */
    void startMeasurement();

    /** Returns the distance in cm. Requires previous call of startMeasurement().
     * @returns distance of the measuring object in cm.
     */
    float getDistance_cm();

    /** Returns the distance in mm. Requires previous call of startMeasurement().
     * @returns distance of the measuring object in mm.
     */
    float getDistance_mm();

    /** Sets the minimum and maximum ranges between the factory values of 2 cm and 400 cm.
     *  @param minRange Minimum range in cm. Must be between 2 cm and maxRange.
     *  @param maxRange Maximum range in cm. Must be between minRange and 400 cm.
     */
    void setRanges(float minRange, float maxRange);

    /** Retreives the minimum sensor range set by the user.
     * @returns the minimum sensor range set by the user in cm.
     */
    float getMinRange();

    /** Retreives the maximum sensor range set by the user.
     * @returns the maximum sensor range set by the user in cm.
     */
    float getMaxRange();

    /** Checks if the new data is ready.
     * @returns true if new data is ready, false otherwise.
     */
    bool isNewDataReady();

    private:

    InterruptIn echo;       // echo pin
    DigitalOut trigger;     // trigger pin
    Timer timer;            // echo pulsewidth measurement
    float distance;         // store the distance in cm
    float minDistance;      // minimum measurable distance
    float maxDistance;      // maximum measurable distance
    Timeout triggerTimeout, echoTimeout;
    bool newDataReady, timerStarted;

	 static const int SENSOR_TIMEOUT = 25000;		// Max posible signal duration (if there is an obstacle)

    /** Start the timer. */
    void startTimer();

    /** Stop the timer. */
    void stopTimer();

    /** Initialization. */
    void init();

	 /** Turn off the trigger */
    void turnOffTrigger();

	 /** Distance calculation */
	 void calculateDistance();
};

#endif
