#include <global.h>

Serial RS2(UART2_TX, UART2_RX);
Serial RS1(UART1_TX, UART1_RX);

DigitalOut Select1(DE_TXD_1);
DigitalOut Select2(DE_TXD_2);

AS5045 Enc_left(SP1_NSS1);
AS5045 Enc_right(SP1_NSS2);

E18_D80NK IR_sensor_left (PB_13);
E18_D80NK IR_sensor_right (PB_12);

DigitalIn  Lift1 (PB_0);
DigitalIn  Lift2 (PB_1); 

JSN_SR04 US_sensor_left (PB_14, PA_9);
JSN_SR04 US_sensor_middle (PB_15, PA_9);
JSN_SR04 US_sensor_right (PA_8, PA_9);  

OneWire oneWire(PA_11);        // substitute D8 with the actual pin name connected to the 1-wire bus

Timer timer;
Watchdog  watchDog;

typedef uint8_t byte;


char c = '1';
int Enc_left_data = 0, Enc_right_data = 0, sensorsFound = 0, US1_data = 0,US2_data = 0, US3_data = 0, Lift_IR1 = 0,Lift_IR2 = 0;
bool IR1_data = 0,IR2_data = 0, sendFlag = false;
float temp_one_value = -1, temp_two_value = -1;


void Encoders()
{
    Enc_left_data = Enc_left.getPosition();
    wait_ms(3);
    Enc_right_data = Enc_right.getPosition();
    wait_ms(3);

    Select1 = 1;
    RS1.printf ("%d_%d\r\n", Enc_right_data, Enc_left_data);
    wait_ms(3);
    Select1 = 0;
}

void UART2_callback()
{
    c =  RS2.getc();
    if(c == '5') {
        sendFlag = true;
    } else {
        Select2 = 1;
        wait_ms(90);
        Select2 = 0;
    }
}
int main()
{
    RS1.baud (115200);
    RS2.baud (115200);
    RS2.attach(&UART2_callback); 
    
    Select1 = 0;
    Select2 = 0; 

    timer.start();

    watchDog.Configure(5.0); 

    US_sensor_left.setRanges (20, 300);
    US_sensor_middle.setRanges (20, 300);
    US_sensor_right.setRanges (20, 300);

    for (sensorsFound = 0; sensorsFound < MAX_SENSOSRS; sensorsFound++) {
        ds1820[sensorsFound] = new DS1820(&oneWire);
        if (!ds1820[sensorsFound]->begin()) {
            delete ds1820[sensorsFound];
            break;
        }
    }

    while (true) {
        watchDog.Service();
        
        Encoders();
        
        for (int i = 0; i < sensorsFound; i++) {
            ds1820[i]->startConversion();
            wait_ms(1);
        }
        
        Encoders();

        US_sensor_left.startMeasurement ();
        US1_data = US_sensor_left.getDistance_cm ();
        wait_ms(20);
        
        Encoders();

        US_sensor_middle.startMeasurement ();
        US2_data = US_sensor_middle.getDistance_cm ();
        wait_ms(20);
        
        Encoders();

        US_sensor_right.startMeasurement ();
        US3_data = US_sensor_right.getDistance_cm ();
        wait_ms(20);
        
        Encoders();

        IR1_data = IR_sensor_left.checkObstacle ();
        IR2_data = IR_sensor_right.checkObstacle ();

        Lift_IR1 = Lift1.read();
        Lift_IR2 = Lift2.read();
        
        Encoders();

        if (ds1820[0]->isPresent() ) {
            temp_one_value = ds1820[0]->read();
        }
        if (ds1820[1]->isPresent() ) {
            temp_two_value = ds1820[1]->read();
        }
        
        Encoders();   

        if(sendFlag) {
            Select2 = 1;
            RS2.printf ("%d_%d_%d_%d_%d_%d_%d_%f_%f\r\n", US1_data, US2_data, US3_data, IR1_data, IR2_data, Lift_IR1, Lift_IR2, temp_one_value, temp_two_value);  
            wait_ms(5);
            sendFlag = false;
            Select2 = 0;
        }
        
        Encoders();
    }
}