#include "definitions.txt"


/*Defines for PicID of display*/
#define SCREEN_OFF 0x00
#define SCREEN_STARTUP 0x01
#define SCREEN_INIT 10
#define SCREEN_CALIBRATING 0x14
#define SCREEN_MAIN_MENU 0x28
#define SCREEN_IN_OPERATION 0x32

#define OPTION_CMD_VP 0x8/* OKadress to write cmd, send from display to mcu
the value in this address must be the ascii value for the char*/
#define MOV_MOTOR_VP 0x102
#define DRIVE_PRESSURE_VP 0x100 //Pressao P.P tela 40
#define PEEP_TARGET_VP 0x340 //OK Pressao Peep tela 40
#define TINS_VP 0x110 //T. INspiracao tela40
#define BPM_VP 0x120 //Bpm tela 40
#define BREATH_TURN_ONOFF_VP 0x03E1//OK Botão Inicia da tela 40
#define ASSISTED_SENSIBILITY_VP 0x350 //Modo Assistido tela 40
#define KI_VP 0x110
#define KP_VP 0x112
#define KD_VP 0x114
#define FIO2_VP 0x125 //FiO2 Tela 40
#define ONOFF_ASSISTED_MODE_VP 0x170 //MODO ASSISTIDO tela 40

#define MODSERIAL_DEFAULT_RX_BUFFER_SIZE 512
#define MODSERIAL_DEFAULT_TX_BUFFER_SIZE 1024 

Timer timer_main;

Serial serial_to_pulga(P0_11, P0_8);

float rx_pot[4];

/*convert float data to fixed point data type*/
uint16_t float_to_fixed(float input, int fix_bits)
{
    return (uint16_t)(input * (1 << fix_bits));
}



/*Do the scale converstion between analogic input (0 - 1) to Scale type wished
@scale: scale to convert the pot val
@pot_val: Analog input from potentiometer, it will take only 2 decimal digits,
it is necessary to avoid floating of number to control code 
*/
float calc_scaled_value(unsigned int scale, float pot_val){
    float ret;
    int temp;
    temp = (pot_val * 100);
    pot_val = (temp / 100); 
    switch(scale){
        case SCALE_PP_PRESSURE:
            ret = (pot_val * 34) + 1; 
            break;
        case SCALE_PEEP_PRESSURE:
            ret = (10 * pot_val) + 5;
            break;
        case SCALE_BPM:
            ret = (20 * pot_val) + 10;
            break;
        case SCALE_TINSP:
            ret = (2.5 * pot_val) + 0.5;
            break;
        case SCALE_FIO2:
            ret = (79 * pot_val) + 21;
            break;
        case SCALE_SENS_ASSISTED_MOD:
            ret = (9 * pot_val) + 1;
            break;
        default:
            ret = pot_val;
            break;
    }
    return ret;
}


int update_parameter(float scaled_value, uint16_t vp, float min, float max, int fix_bits){
    uint16_t data[1];
    uint16_t aux;
    if(scaled_value > max) scaled_value = max;
    if(scaled_value < min) scaled_value = min;
    if(fix_bits >0){
        scaled_value = scaled_value * 10;
        data[0] = (uint16_t)scaled_value;
    }
    else
        data[0] = (uint16_t)scaled_value;
    proculus_set_vp(0x5, vp, data);
    return 0;
}



/*specific routine to get the screen at rx irq routine*/
void get_screen_at_irq(){
    proculus_get_ctrl(0x3, PIC_ID_H, 0x2); 
}

void update_screen(){
    //update P.P Pressure
    update_parameter(calc_scaled_value(SCALE_PP_PRESSURE, rx_pot[0]),
                     DRIVE_PRESSURE_VP, 1.0, 35, 1
                     );
    //update BPM ok
    update_parameter(calc_scaled_value(SCALE_BPM, rx_pot[1]),
                     BPM_VP, 10, 30, 0
                     );
    //update TINSP
    update_parameter(calc_scaled_value(SCALE_TINSP, rx_pot[2]),
                     TINS_VP, 0.5, 3.0, 1
                     );
    //update FIO2 (Oxigen%)
    update_parameter(calc_scaled_value(SCALE_FIO2, rx_pot[3]),
                     FIO2_VP, 21, 100, 0
                     );
}

int bc = 0;//byte couter
int i_rx = 0;//counter to start receive rx at serial

void clear_display_buffer(){
    int i = 0;
    char msg[30] = "DISPLAY:";
    char t[3];
    while(i<7){
        sprintf(t,"%x",serial_rx_buffer[i]);
        strcat(msg, t);
        serial_rx_buffer[i] = 0x0;
        i++;
    }   
    //pc.puts(msg);
    //pc.puts("\n"); 
}

#define DELAY_UART 2000 //us
void serial_rx_irq(){
    int time_us;
    char debug_msg[100];
    char temp_char[10];
    char rx_buffer[50] = "0";
    int i = 0, j=0, k;
    int bytes_to_rcv = 0;
    struct proculus_pkt pkt; //to manage data
    uint16_t data[255];//to store data
    pkt.buffer = data;
    int unknow = 1;//if unknow pkt come
    while(serial1.readable()){
            serial_rx_buffer[i_rx] = serial1.getc();
            i_rx++;
            if(i_rx>=8){
                i_rx = 0;
                //pc_puts(rx_pulga_buffer, 7);
                break;
            }
    }
    /*
    *Never remove the timer serial_timer, it keep the mininum time between
    *two uart datas, if you have problem with serial, try change the DELAY_UART
    *value, mbed api do not says anything about this timing issue
    */
    /*serial_timer.reset();//restart timer
    serial_timer.start();
    time_us = serial_timer.read_us();
    while(time_us<DELAY_UART){
        time_us = serial_timer.read_us();
    }*/
    //if(time_us >= DELAY_UART) 
    //{
        /*if(serial_rx_buffer[0] != 0x5a){ 
            i_rx = 0;
            //bc = 255;
        }
        if(i_rx >1 && serial_rx_buffer[1] != 0xa5){
            i_rx = 0;
            //bc = 255;
        }*/
        
       /* while(serial1.readable()){//get only one byte per interrupt
            serial_timer.reset();//restart timer
            serial_timer.start();
            time_us = serial_timer.read_us();
            while(time_us<DELAY_UART){
                time_us = serial_timer.read_us();
            }
            if(serial_rx_buffer[0] != 0x5a){ 
               i_rx = 0;
            //bc = 255;
            }
            if(i_rx >1 && serial_rx_buffer[1] != 0xa5){
                i_rx = 0;
            //bc = 255;
            }
            serial_rx_buffer[i_rx] = serial1.getc();
            if(i_rx == 2)//get bc(how many byts will come
                bc = serial_rx_buffer[2];
            //sprintf(debug_msg,"serial_rx_buffer[%d] = %x\n",i_rx ,serial_rx_buffer[i_rx]);
            //pc.puts(debug_msg);
            if(bc > 0 && i_rx >2)//avoid decrement it when it  was got
                bc--;
            i_rx++;
        }
        
        /*if(i_rx == 2)//get bc(how many byts will come
            bc = serial_rx_buffer[2];*/
        
    //}
    /*while(serial1.readable()){
        serial_rx_buffer[i] = serial1.getc();
        serial_timer.reset();
        time_us = serial_timer.read_us();
        while(time_us < DELAY_UART) 
        {
          time_us = serial_timer.read_us();
        }
        i++;
    }*/
    //serial_timer.reset();//restart timer
    //serial_timer.start();
    //serial_timer.stop();
    //j = 0;
    //sprintf(debug_msg, "rx_bytes:%d \n bc = %d\n", i_rx, bc);
    //pc.puts(debug_msg);
    if(i_rx == 0){//packt was received
        /*if(serial_rx_buffer[2] >= 0x80 && serial_rx_buffer[2] <= 0x84)  
        {    
            serial_to_proculus_pkt_2(serial_rx_buffer, &pkt);
            unknow=0;
        }*/
        if(serial_rx_buffer[3] >= 0x80 && serial_rx_buffer[3] <= 0x84)  
        {    
            serial_to_proculus_pkt(serial_rx_buffer, &pkt);
            unknow=0;
        }
        else
            unknow = 1;//received something unknow
    }
    
    if(unknow == 0){ 
        if(pkt.cmd == W_VP){
            switch(pkt.address){
                case PEEP_TARGET_VP:
                    display_option = 'e';
                    display_data = pkt.buffer[0];//ISSUE is this data in fix point?
                    display_ctrl = DISPLAY_CMD_DATA_ARRIVE;
                    break;
                case ASSISTED_SENSIBILITY_VP:
                    display_option = 's';
                    display_data = pkt.buffer[0];//ISSUE is this data in fix point?
                    display_ctrl = DISPLAY_CMD_DATA_ARRIVE;
                    break;   
                default:
                    break;
            }
        }   
        if(pkt.cmd == R_VP){
            switch(pkt.address){
            case OPTION_CMD_VP:
                display_ctrl = DISPLAY_CMD_START;//active in next serial loop to do the ctrl
                display_option = (char)pkt.buffer[0];
                switch(display_option){//if this CMD needs data claim for it
                case 'm':
                    proculus_get_vp(0x4, MOV_MOTOR_VP, 0x1);
                    display_ctrl = DISPLAY_CMD_WAITING_DATA; //wait for data from display
                    break;
                case 'p'://just show value in display
                //    update_parameter(calc_scaled_value(SCALE_PP_PRESSURE, Pot1.read()),
                 //    DRIVE_PRESSURE_VP, 'p', 1.0, 35, 3
                  //   );
                    break;
                case 'e':
                    proculus_get_vp(0x4, PEEP_TARGET_VP, 0x1);
                    display_ctrl = DISPLAY_CMD_WAITING_DATA; //wait for data from display
                    break;
                case 't':
                    //update_parameter(calc_scaled_value(SCALE_TINSP, Pot3.read()),
                    // TINS_VP, 't', 0.5, 3.0, 4
                    // );
                    break;
                case 'c':
                    //update_parameter(calc_scaled_value(SCALE_BPM, Pot2.read()),
                    // BPM_VP, 'c', 10, 30, 8
                    // );
                    break;
                case 'S':
                    proculus_get_vp(0x4, BREATH_TURN_ONOFF_VP, 0x1);
                    display_ctrl = DISPLAY_CMD_WAITING_DATA; //wait for data from display
                    break;
                case 's':
                    proculus_get_vp(0x4, ASSISTED_SENSIBILITY_VP, 0x1);
                    display_ctrl = DISPLAY_CMD_WAITING_DATA; //wait for data from display
                    break;
                case 'I':
                    proculus_get_vp(0x4, KI_VP, 0x1);
                    display_ctrl = DISPLAY_CMD_WAITING_DATA; //wait for data from display
                    break;
                case 'P':
                    proculus_get_vp(0x4, KP_VP, 0x1);
                    display_ctrl = DISPLAY_CMD_WAITING_DATA; //wait for data from display
                    break;
                case 'D':
                    proculus_get_vp(0x4, KD_VP, 0x1);
                    display_ctrl = DISPLAY_CMD_WAITING_DATA; //wait for data from display
                    break;
                case 'o':
                    //update_parameter(calc_scaled_value(SCALE_FIO2, Pot4.read()),
                    // FIO2_VP, 'o', 0.5, 21, 100
                    // );
                    break;
                case 'A':
                    proculus_get_vp(0x4, ONOFF_ASSISTED_MODE_VP, 0x1);
                    display_ctrl = DISPLAY_CMD_WAITING_DATA; //wait for data from display
                    break;    
                default:
                    //print warning
                    break;
                }//switch    
                break;
            case BREATH_TURN_ONOFF_VP://TEST OK
                display_option = 'S';
                display_data = pkt.buffer[0];//for while let it as single uint16
                display_ctrl = DISPLAY_CMD_DATA_ARRIVE; //wait for data from display
                break;
            case PEEP_TARGET_VP:
                display_option = 'e';
                display_data = pkt.buffer[0];//ISSUE is this data in fix point?
                display_ctrl = DISPLAY_CMD_DATA_ARRIVE;
                break;
            case ASSISTED_SENSIBILITY_VP:
                //sprintf(debug_msg,"Assi_sens = %x \n", pkt.buffer[0]);
                //pc.puts(debug_msg);
                display_option = 's';
                display_data = pkt.buffer[0];//ISSUE is this data in fix point?
                display_ctrl = DISPLAY_CMD_DATA_ARRIVE;
                break; 
            default:
                 break;
            }//switch
        }//if
        if(pkt.cmd == R_CTRL_REG){//from a read control register comand
            //pc.puts("control reg \n");
            if(pkt.address == PIC_ID_H){//read screen cmd
                screen_id = (pkt.buffer[0] << 8 );
                screen_id |= pkt.buffer[1];
                //sprintf(debug_msg,"screen_id = %x \n", screen_id);
                //pc.puts(debug_msg);
                //if(PISTON_HOM_PIN == HIGH){
                    switch(screen_id){
                        case SCREEN_CALIBRATING:
                            jump_to_screen(SCREEN_MAIN_MENU);
                            break;
                        case SCREEN_INIT:
                            jump_to_screen(SCREEN_CALIBRATING);
                            break; 
                        case SCREEN_OFF:
                            jump_to_screen(SCREEN_STARTUP);
                            break;
                        case SCREEN_STARTUP:
                            jump_to_screen(SCREEN_INIT);
                            break;
                        default:
                            //print warning
                            break;
                    }
                //}else{
                  //  jump_to_screen(SCREEN_MAIN_MENU);
                //}
            }
        }
        clear_display_buffer();
        i_rx = 0;
    }
}

struct pulga_pkt {
    uint8_t header_h;
    uint8_t header_l;
    uint8_t count;
    uint8_t cmd;
    uint16_t address;
    uint16_t *buffer;
};


//PULGA TO PULGA SERIAL PROTOCOL P2PS
/*9A A9       BC          CMD       DATA
  HH HL   Byte to come   Command    datas
*/

#define PULGA_CMD_SEND_POT_DATA 0x40
/*
*serial_to_proculus_pkt: get the data received in serial rx and translate
*to proculus_pkt
*@pkt is pointer to the struct to store datas
*/
int serial_to_pulga_pkt(char *serial_data, struct pulga_pkt *pkt){
    pkt->header_h = serial_data[0];
    pkt->header_l = serial_data[1];
    pkt->count = serial_data[2];
    pkt->cmd = serial_data[3];
    if(pkt->cmd == PULGA_CMD_SEND_POT_DATA){
        pkt->address = serial_data[4];
        pkt->buffer[0] = (serial_data[5] << 8);
        pkt->buffer[0] |= serial_data[6];
    }
    return 0;
}
char rx_pulga_buffer[100];
void clear_pulga_buffer(){
    int i = 0;
    char msg[30] = "PKT:";
    char t[3];
    while(i<7){
        sprintf(t,"%x",rx_pulga_buffer[i]);
        strcat(msg, t);
        rx_pulga_buffer[i] = 0x0;
        i++;
    }   
    //pc.puts(msg);
    //pc.puts("\n"); 
}

//***********************************************************************************************
#define DELAY_P2PS 10000 //us

int rx_i = 0;
int pulga_bc = 0;
Timer pulga_rx_timer;
void serial_pulga_rx(){
    int i=0, unknow = 1;
    struct pulga_pkt pulga_pkt;
    uint16_t data[2];
    int time_us;
    char debug_msg[100];
    pulga_pkt.buffer = data;
    while(serial_to_pulga.readable()){
            rx_pulga_buffer[rx_i] = serial_to_pulga.getc();
            rx_i++;
            if(rx_i>=7){
                rx_i = 0;
                //pc_puts(rx_pulga_buffer, 7);
                break;
            }
    }
    //pulga_rx_timer.reset();//restart timer
    //pulga_rx_timer.start();
    //time_us = pulga_rx_timer.read_us();
    //while(time_us<DELAY_P2PS){
    //    time_us = pulga_rx_timer.read_us();
    //}
    /*if(rx_pulga_buffer[0] != 0x9a){ 
        rx_i = 0;
    }
    if(rx_i >1 && rx_pulga_buffer[1] != 0xa9){
        rx_i = 0;
    }*/
    /*
    while(serial_to_pulga.readable()){//get only one byte per interrupt
        if(rx_pulga_buffer[0] != 0x9a){//avoid noise 
            rx_i = 0;
            pulga_bc = 0;
            clear_pulga_buffer();
        }
        if(rx_i >1 && rx_pulga_buffer[1] != 0xa9){//avoid noise
            rx_i = 0;
            pulga_bc = 0;
            clear_pulga_buffer();
        }
        if( i>3 && rx_pulga_buffer[3] < 0x40 || rx_pulga_buffer[3] > 0x49){//avoid noise
            rx_i = 0;
            pulga_bc = 0;
            clear_pulga_buffer();
        }
        
        pulga_rx_timer.reset();//restart timer
        pulga_rx_timer.start();
        time_us = pulga_rx_timer.read_us();
        while(time_us<DELAY_P2PS){
            time_us = pulga_rx_timer.read_us();
        }
        rx_pulga_buffer[rx_i] = serial_to_pulga.getc();
        
        if(rx_i == 2)//get bc(how many byts will come
            pulga_bc = rx_pulga_buffer[2];
        
        if(pulga_bc > 0 && rx_i > 2)//avoid decrement it when it  was got
            pulga_bc--;
          
        sprintf(debug_msg,"rx_pulga_buffer[%d] = %x\n",rx_i ,rx_pulga_buffer[rx_i]);
        pc.puts(debug_msg);
        sprintf(debug_msg,"pulga_bc = %d\n",pulga_bc);
        pc.puts(debug_msg);
        
        
        rx_i++;
        if(pulga_bc == 0 && rx_i > 2)
            rx_i = 0;
    }
    */ 
    /*if(rx_i == 2)//get bc(how many byts will come
        pulga_bc = rx_pulga_buffer[2];*/
    
    if(rx_i ==0){
        if(rx_pulga_buffer[3] >= 0x40 && rx_pulga_buffer[3] <= 0x49)  
        {    
            serial_to_pulga_pkt(rx_pulga_buffer, &pulga_pkt);
            unknow=0;
        }
        else
            unknow = 1;//received something unknow
    }
    if(unknow == 0){
        //Do logic Here
        if(pulga_pkt.cmd == PULGA_CMD_SEND_POT_DATA){
            rx_pot[pulga_pkt.address - 1] = (pulga_pkt.buffer[0] / 1000);
        }
        clear_pulga_buffer();
        rx_i = 0;
    }
        
}

void Setup() 
//Description: Main setup function, called after power on or reset
//Inputs:   void
//Outputs:  void
{
    
    //setup the device rx irq handler
    //serial1.attach(&serial_rx_irq, RawSerial::RxIrq);
    //serial_to_pulga.attach(&serial_pulga_rx, RawSerial::RxIrq);
    //setup the baud rate to match with display
    serial1.baud(115200);
    serial_to_pulga.baud(9600);
    
    //display_timeout.attach(&get_screen_at_irq, 0.5);
    display_ticker.attach(&get_screen_at_irq, 0.4);
    //display_ticker.attach(&update_screen, 0.3);
    
}

void Send_to_pulga(){
    char temp[20];
    if(display_option != '\0')
    {
        serial_to_pulga.putc(display_option);
        display_option = '\0';
    }
    
    if(display_ctrl == DISPLAY_CMD_DATA_ARRIVE)
    {
        sprintf(temp, "%f", display_data);
        serial_to_pulga.puts(temp);
        display_ctrl = DISPLAY_CMD_DONE;
    }
}

/*int pc_puts(const char *str, int size){
    int i = 0;
    while(i < size){
        pc.putc(str[i]);
        i++;
    }
    return 0;
}*/

//***********************************************************************************************
int main()
{
    wait(3);//time to display setup. not sure about this value
    Setup();
    jump_to_screen(SCREEN_STARTUP);
    int i = 0;
    while (true) {
        //jump_to_screen(SCREEN_STARTUP);
        //update_screen();
        //Send_to_pulga();
        serial_pulga_rx();
        wait(0.2);
        serial_rx_irq();
    }
}