/**
 * Copyright (c) 2017, Arm Limited and affiliates.
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include <stdio.h>
#include "mbed.h"

//#include "lorawan/LoRaWANInterface.h"
//#include "lorawan/system/lorawan_data_structures.h"
//#include "events/EventQueue.h"

// Application helpers
//#include "DummySensor.h"
#include "trace_helper.h"
//#include "lora_radio_helper.h"
//#include "BME280.h"

#include "serial.h"
#include "gps.h"


using namespace events;


//mbed::RawSerial pc(P0_28, P0_25);
//Ticker serial_rx_ticker;
// Max payload size can be LORAMAC_PHY_MAXPAYLOAD.
// This example only communicates with much shorter messages (<30 bytes).
// If longer messages are used, these buffers must be changed accordingly.
//uint8_t tx_buffer[256];
//uint8_t rx_buffer[30];

/*
 * Sets up an application dependent transmission timer in ms. Used only when Duty Cycling is off for testing
 */
#define TX_TIMER                        10000

/**
 * Maximum number of events for the event queue.
 * 10 is the safe number for the stack events, however, if application
 * also uses the queue for whatever purposes, this number should be increased.
 */
#define MAX_NUMBER_OF_EVENTS            10

/**
 * Maximum number of retries for CONFIRMED messages before giving up
 */
#define CONFIRMED_MSG_RETRY_COUNTER     3

/**
 * Dummy pin for dummy sensor
 */
//#define PC_9                            0

/**
 * Dummy sensor class object
 */
//DS1820  ds1820(PC_9);
//BME280 sensor_amb(P0_13, P0_15, 0x77 << 1) ;

/**
 * Sensors Variables
 */
//        uint32_t lux = 0;
//        uint32_t amb = 0;
//        float  sensor_get = 0;

void serial_post_to_queue(void);

/**
* This event queue is the global event queue for both the
* application and stack. To conserve memory, the stack is designed to run
* in the same thread as the application and the application is responsible for
* providing an event queue to the stack that will be used for ISR deferment as
* well as application information event queuing.
*/
static EventQueue ev_queue(MAX_NUMBER_OF_EVENTS *EVENTS_EVENT_SIZE);

/**
 * Event handler.
 *
 * This will be passed to the LoRaWAN stack to queue events for the
 * application which in turn drive the application.
 */
//static void lora_event_handler(lorawan_event_t event);

/**
 * Constructing Mbed LoRaWANInterface and passing it the radio object from lora_radio_helper.
 */
//static LoRaWANInterface lorawan(radio);

/**
 * Application specific callbacks
 */
static lorawan_app_callbacks_t callbacks;

/**
 * Entry point for application
 */
 
mbed::DigitalOut _alive_led(P1_13, 0);
mbed::DigitalOut _actuated_led(P1_14,1);
//int lat=0;
//int lon=0;
int latitude=0;
int longitude=0;


//Temperature, Pressure, Humidity Sensor
#include "BME280.txt"
#include "BMX160.txt"
//#include "gps.txt"

void BMX160Read (void)
{    
    /*Le os Registradores do Acelerometro*/
        i2c_reg_buffer[0] = 0x12;
        i2c.write(BMI160_ADDR, i2c_reg_buffer, 1, true);
        i2c.read(BMI160_ADDR, (char *)&acc_sample_buffer, sizeof(acc_sample_buffer), false);
        
        /*Le os Registradores do Giroscopio*/
        i2c_reg_buffer[0] = 0x0C;
        i2c.write(BMI160_ADDR, i2c_reg_buffer, 1, true);
        i2c.read(BMI160_ADDR, (char *)&gyr_sample_buffer, sizeof(gyr_sample_buffer), false);
        
        /*Ajusta dados brutos Acelerometro em unidades de g */
        acc_result_buffer[0] = (acc_sample_buffer[0]/16384.0);
        acc_result_buffer[1] = (acc_sample_buffer[1]/16384.0);
        acc_result_buffer[2] = (acc_sample_buffer[2]/16384.0);
        
        /*Ajusta dados Brutos do Giroscopio em unidades de deg/s */
        gyr_result_buffer[0] = (gyr_sample_buffer[0]/131.2);
        gyr_result_buffer[1] = (gyr_sample_buffer[1]/131.2);
                
        /*Calcula os Angulos de Inclinacao com valor do Acelerometro*/
        accel_ang_x=atan(acc_result_buffer[0]/sqrt(pow(acc_result_buffer[1],2) + pow(acc_result_buffer[2],2)))*RAD_DEG;
        accel_ang_y=atan(acc_result_buffer[1]/sqrt(pow(acc_result_buffer[0],2) + pow(acc_result_buffer[2],2)))*RAD_DEG;
        
        /*Calcula os Angulos de Rotacao com valor do Giroscopio e aplica filtro complementar realizando a fusao*/
        tiltx = (0.98*(tiltx_prev+(gyr_result_buffer[0]*0.001)))+(0.02*(accel_ang_x));
        tilty = (0.98*(tilty_prev+(gyr_result_buffer[1]*0.001)))+(0.02*(accel_ang_y));
        
        tiltx_prev = tiltx;
        tilty_prev = tilty;                                 
        
        /*Imprime os dados ACC pre-formatados*/
        printf("%.3f,%.3f;",tiltx, tilty);
    
    }

void GPS_Read(void)
{
    gps_print_local();
    pc.printf ("gps longitude=%d \n",get_longitude());
    pc.printf ("gps latitude=%d \n",get_latitude());
    if(lat!=0 && lon!=0){
        longitude=get_longitude();
        latitude=get_latitude();
//        led1 = !led1;
    }
}

void serial_rx(){
    if(pc.readable()){
        pc.printf("rx: %c\n", pc.getc());
    } 
    pc.attach(&serial_post_to_queue, RawSerial::RxIrq);
    return;
}
 
void serial_post_to_queue(void){
    //disable serial rx interrupt
    pc.attach(NULL, RawSerial::RxIrq);
    //enqueue the serial rx reception as a normal task
    ev_queue.call(SerialRx);
    return;
}

int main(void)
{
    pc.printf("init\n");
    pc.baud(9600);
    pc.printf("config9600\n");
    //enable serial rx interrupt
    pc.attach(&serial_post_to_queue, RawSerial::RxIrq);
    gps_config();
    gps_leBootMsg();
    gps_config_gnss ();
    init();
    
    //BMX160 Declaration######################################
    //    pc.printf("Teste BMI160\n\r");
//    printf("Configurando BMX160...\n\r");
    wait_ms(250);
    
    /*Config Freq. I2C Bus*/
    i2c.frequency(20000);
    
    /*Reset BMI160*/
    i2c_reg_buffer[0] = 0x7E;
    i2c_reg_buffer[1] = 0xB6;    
    i2c.write(BMI160_ADDR, i2c_reg_buffer, sizeof(i2c_reg_buffer), false);
    wait_ms(200);
//    printf("BMI160 Resetado\n\r");
    
    /*Habilita o Acelerometro*/
    i2c_reg_buffer[0] = 0x7E;
    i2c_reg_buffer[1] = 0x11; //PMU Normal   
    i2c.write(BMI160_ADDR, i2c_reg_buffer, sizeof(i2c_reg_buffer), false);
//    printf("Acc Habilitado\n\r");
    
    /*Habilita o Giroscopio*/
    i2c_reg_buffer[0] = 0x7E;
    i2c_reg_buffer[1] = 0x15;  //PMU Normal 
    i2c.write(BMI160_ADDR, i2c_reg_buffer, sizeof(i2c_reg_buffer), false);
//    printf("Gyr Habilitado\n\r");
    
    /*Config o Data Rate ACC em 1600Hz*/
    i2c_reg_buffer[0] = 0x40;
    i2c_reg_buffer[1] = 0x2C;    
    i2c.write(BMI160_ADDR, i2c_reg_buffer, sizeof(i2c_reg_buffer), false);
//    printf("Data Rate ACC Selecionado a 1600Hz\n\r");
    
    /*Config o Data Rate GYR em 1600Hz*/
    i2c_reg_buffer[0] = 0x42;
    i2c_reg_buffer[1] = 0x2C;    
    i2c.write(BMI160_ADDR, i2c_reg_buffer, sizeof(i2c_reg_buffer), false);
//    printf("Data Rate GYR Selecionado a 1600Hz\n\r");
    
    /*Config o Range GYR em 250º/s*/
    i2c_reg_buffer[0] = 0x43;
    i2c_reg_buffer[1] = 0x03;    
    i2c.write(BMI160_ADDR, i2c_reg_buffer, sizeof(i2c_reg_buffer), false);
//    printf("Range GYR Selecionado a 250deg/s\n\r");
    
    pc.printf("BMX160 Configurado\n\r");
    
    //########################################################
    // setup tracing
    setup_trace();

    // stores the status of a call to LoRaWAN protocol
    lorawan_status_t retcode;

    // Initialize LoRaWAN stack
    /*if (lorawan.initialize(&ev_queue) != LORAWAN_STATUS_OK) {
        pc.printf("\r\n LoRa initialization failed! \r\n");
        return -1;
    }*/
    
    if(lorawan_initialize_stack(&ev_queue) != 0){
        return -1;
    }

    pc.printf("\r\n Mbed LoRaWANStack initialized \r\n");

    // prepare application callbacks
    /*callbacks.events = mbed::callback(lora_event_handler);
    lorawan.add_app_callbacks(&callbacks);
    */
    
    callbacks.events = mbed::callback(lora_event_handler);
    lorawan_add_callbacks(callbacks);
    
    // Set number of retries in case of CONFIRMED messages
    /*if (lorawan.set_confirmed_msg_retries(CONFIRMED_MSG_RETRY_COUNTER)
            != LORAWAN_STATUS_OK) {
        pc.printf("\r\n set_confirmed_msg_retries failed! \r\n\r\n");
        return -1;
    }*/
    
    if(lorawan_set_confirmed_msg_retries(CONFIRMED_MSG_RETRY_COUNTER) != 0){
        pc.printf("\r\n set_confirmed_msg_retries failed! \r\n\r\n");
        return -1;
    }
    

    pc.printf("\r\n CONFIRMED message retries : %d \r\n",
           CONFIRMED_MSG_RETRY_COUNTER);
    /*
    // Enable adaptive data rate
    if (lorawan.enable_adaptive_datarate() != LORAWAN_STATUS_OK) {
        pc.printf("\r\n enable_adaptive_datarate failed! \r\n");
        return -1;
    }
    */
    
    if(lorawan_enable_adaptive_datarate() != 0){
        pc.printf("\r\n enable_adaptive_datarate failed! \r\n");
        return -1;
    }
    

    pc.printf("\r\n Adaptive data  rate (ADR) - Enabled \r\n");
    
    /*
    retcode = lorawan.connect();

    if (retcode == LORAWAN_STATUS_OK ||
            retcode == LORAWAN_STATUS_CONNECT_IN_PROGRESS) {
    } else {
        pc.printf("\r\n Connection error, code = %d \r\n", retcode);
        return -1;
    }
    */
    
    if(lorawan_connect() != 0){
        pc.printf("\r\n Connection error, code = %d \r\n", retcode);
        return -1;
    }
    
    pc.printf("\r\n Connection - In Progress ...\r\n");
    
    _actuated_led =0;
    
    //
    // make your event queue dispatching events forever
    ev_queue.dispatch_forever();
    return 0;
}

/**
 * Sends a message to the Network Server
 */
 /*
static void send_message()
{
    uint16_t packet_len;
    int16_t retcode;
    int32_t sensor_value;
    gps_print_local();
    
    packet_len = sprintf((char *) tx_buffer, "%2.2f, %04.2f, %2.2f, %d, %d\n", getTemperature(), getPressure(), getHumidity(), get_longitude(), get_latitude());

    retcode = lorawan.send(MBED_CONF_LORA_APP_PORT, tx_buffer, packet_len,
                           MSG_UNCONFIRMED_FLAG);

    if (retcode < 0) {
        retcode == LORAWAN_STATUS_WOULD_BLOCK ? pc.printf("send - WOULD BLOCK\r\n")
        : pc.printf("\r\n send() - Error code %d \r\n", retcode);

        if (retcode == LORAWAN_STATUS_WOULD_BLOCK) {
            //retry in 3 seconds
            if (MBED_CONF_LORA_DUTY_CYCLE_ON) {
                ev_queue.call_in(10000, send_message);
            }
        }
        return;
    }

    pc.printf("%2.2f;%04.2f;%2.2f;", getTemperature(), getPressure(), getHumidity());
    BMX160Read();
    pc.printf ("%d;",get_longitude());
    pc.printf ("%d \r\n",get_latitude());
//    printf("\r\n %d bytes scheduled for transmission \r\n", retcode);
    memset(tx_buffer, 0, sizeof(tx_buffer));
}
*/

/**
 * Receive a message from the Network Server
 */
/*static void receive_message()
{
    uint8_t port;
    int flags;
    int16_t retcode = lorawan.receive(rx_buffer, sizeof(rx_buffer), port, flags);

    if (retcode < 0) {
//        printf("\r\n receive() - Error code %d \r\n", retcode);
        return;
    }

//    printf(" RX Data on port %u (%d bytes): ", port, retcode);
    for (uint8_t i = 0; i < retcode; i++) {
        pc.printf("%02x ", rx_buffer[i]);
    }
    pc.printf("\r\n");
    
    memset(rx_buffer, 0, sizeof(rx_buffer));
}
*/

/**
 * Event handler
 */
void lora_event_handler(lorawan_event_t event)
{
    switch (event) {
        case CONNECTED:
            pc.printf("\r\n Connection - Successful \r\n");
            if (MBED_CONF_LORA_DUTY_CYCLE_ON) {
                //send_message();
                //lora_send_message((uint8_t*)"testeLora", (uint16_t)10);
            } //else {
                //ev_queue.call_every(TX_TIMER, (void)lora_send_message((uint8_t*)"testeLoraEvery", (uint16_t)15));
            //}

            break;
        case DISCONNECTED:
            ev_queue.break_dispatch();
            pc.printf("\r\n Disconnected Successfully \r\n");
            break;
        case TX_DONE:
//            printf("\r\n Message Sent to Network Server \r\n");
            if (MBED_CONF_LORA_DUTY_CYCLE_ON) {
                //lora_send_message((uint8_t*)"teste", (uint16_t)6);
            }
            break;
        case TX_TIMEOUT:
//        printf("\r\n Transmission Error TX_Timeout");
            break;
        case TX_ERROR:
//        printf("\r\n Transmission Error TX_Error");
            break;
        case TX_CRYPTO_ERROR:
//        printf("\r\n Transmission Error TX_Crypto_Error");
            break;
        case TX_SCHEDULING_ERROR:
//            printf("\r\n Transmission Error - EventCode = %d \r\n", event);
            // try again
            if (MBED_CONF_LORA_DUTY_CYCLE_ON) {
                //lora_send_message((uint8_t*)"teste2", (uint16_t)7);
            }
            break;
        case RX_DONE:
//            printf("\r\n Received message from Network Server \r\n");
            lora_receive_message();
            break;
        case RX_TIMEOUT:
//        printf("\r\n Transmission Error RX_Timeout");
            break;
        case RX_ERROR:
//            printf("\r\n Error in reception - Code = %d \r\n", event);
            break;
        case JOIN_FAILURE:
//            printf("\r\n OTAA Failed - Check Keys \r\n");
            break;
        case UPLINK_REQUIRED:
//            printf("\r\n Uplink required by NS \r\n");
            if (MBED_CONF_LORA_DUTY_CYCLE_ON) {
                //lora_send_message((uint8_t*)"uplink", (uint16_t)7);
            }
            break;
        default:
            MBED_ASSERT("Unknown Event");
            break;
    }
}

// EOF
