#ifndef _LORA_RADIO_H
#define _LORA_RADIO_H
/**
 * Copyright (c) 2017, Arm Limited and affiliates.
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include <stdio.h>
#include "mbed.h"

#include "events/EventQueue.h"

#include "lorawan/LoRaWANInterface.h"
#include "lorawan/system/lorawan_data_structures.h"

#include "serial.h"

//#include "lora_radio_helper.h"

extern void lorawan_add_callbacks(lorawan_app_callbacks_t LoraWanCallbacks);

extern void lora_event_handler(lorawan_event_t event);

extern int lorawan_connect(void);

extern int lorawan_enable_adaptive_datarate(void);

extern int lorawan_set_confirmed_msg_retries(unsigned int number_of_retries);
    

extern int lorawan_initialize_stack(EventQueue *ev_queue);

/**
 * Sends a message to the Network Server
 */
extern int lora_send_message(uint8_t *msg_to_transmit, uint16_t pkt_len);

/**
 * Receive a message from the Network Server
 */
extern int lora_receive_message();

#endif