#include "mbed.h"
#include "proculus_display.h"

unsigned int sensor_open;//fim de curso fake

#define SCREEN_CALIBRATING 0x14

uint16_t screen_id = 0x00;

void serial_tx_irq(){
    debug_serial->puts("TX");
}

void serial_rx_irq(){
    int i = 0, j, k;
    struct proculus_pkt pkt;
    uint16_t data[255];
    char msg[100];
    pkt.buffer = data;
    int unknow = 0;
    //sprintf(msg, "rx_to_rcv=%d",rx_to_rcv);
    //debug_serial->puts("_|_");
    //debug_serial->puts(msg);
    while(serial1.readable() || rx_to_rcv >0){
        serial_rx_buffer[i] = serial1.getc();
        i++;
        rx_to_rcv --;
        if(rx_to_rcv <= 0)
            break;
    }
#ifdef DEBUG_SERIAL
    //debug_puts(rx_buffer, i);//print pure data to be read as hex
    if(i>1){
        debug_serial->puts("_|_");
        raw_to_string(serial_rx_buffer, msg, i);
        debug_serial->puts(msg);
        debug_serial->puts("_|_");
        sprintf(msg, "rcvsize=%d",i);
        debug_serial->puts(msg);
        debug_serial->puts("_|_");
    }
    
#endif
    if(i>1  && rx_to_rcv == 0){
        if(serial_rx_buffer[3] >= 0x80 && serial_rx_buffer[3] <= 0x84)  
            //serial_to_proculus_pkt(&pkt);
        {    
            j = 0;
            k = 0;
            pkt.header_h = serial_rx_buffer[0];
            pkt.header_l = serial_rx_buffer[1];
            pkt.count = serial_rx_buffer[2];
            pkt.cmd = serial_rx_buffer[3];
            if(pkt.cmd == R_CTRL_REG){
                pkt.address = serial_rx_buffer[4];
                pkt.lenght = serial_rx_buffer[5];
                while(j < pkt.lenght){
                    pkt.buffer[j] = serial_rx_buffer[6 + j];
                    j++;
                }
            }
            else{
                pkt.address = serial_rx_buffer[4] << 8;
                pkt.address |= serial_rx_buffer[5];
                pkt.lenght = serial_rx_buffer[6];
                while(j < pkt.lenght){
                    pkt.buffer[j] = serial_rx_buffer[7 + k] << 8;
                    pkt.buffer[j] |= serial_rx_buffer[8 + k];
                    j++;
                    k += 2;
                }
            }
            unknow=0;
        }
        else
            unknow = 1;//received something unknow
    }
    
    if(unknow ==0){    
        if(pkt.cmd == R_VP){
        //if(pkt.address == 0x32){
            //data[0] = data[0] + 1;
            //proculus_set_vp(0x5, 10, pkt.buffer);
        //}
        }
        if(pkt.cmd == R_CTRL_REG){//from a read control register comand
            if(pkt.address == PIC_ID_H){//read screen cmd
                screen_id = (pkt.buffer[0] << 8 );
                screen_id |= pkt.buffer[1];
                if(screen_id == SCREEN_CALIBRATING)
                    jump_to_screen(0x46);
                else
                    jump_to_screen(0);
            }else
                jump_to_screen(96);
        }
    }
    else{
        debug_serial->puts("unknowPKT");
        debug_serial->puts("_|_");
    }
        
}


//stop all measures, and stop any action
int system_stop(){
    return 0;
}

int get_screen_at_irq(){
    int i = 0;
    strcpy(serial_rx_buffer, "");
    while(serial1.readable()){//clean anything in buffer before send cmd
        serial_rx_buffer[i] = serial1.getc();
        i++;
    }
    //serial1.attach(0);
    while(rx_to_rcv);
    proculus_get_ctrl(0x3, PIC_ID_H, 0x2);
    //serial1.attach(&serial_rx_irq);
    return 0;    
}

int main()
{
    //simulate sensor "fim de curso"
    sensor_open = 0;
    
    uint16_t data[100];//buffer to store vp datas
    uint16_t ctrl_data[2];//buffer to store ctrl_reg datas
    int i = 0x00, j=0;
    struct proculus_pkt pkt;
    //setup the device rx irq handler
    serial1.attach(&serial_rx_irq, RawSerial::RxIrq);
    //setup the baud rate to match with display
    serial1.baud(115200);
#ifdef DEBUG_SERIAL
    debug_serial->baud(115200);
    debug_serial->puts("start");
#endif
    wait(3);
    sensor_open = 0;
    while(1) {
        
        if(!sensor_open){//are the device secure to operate?
            
            get_screen_at_irq();
            wait(3);
        }else{
            system_stop();
            jump_to_screen(SCREEN_CALIBRATING);
#ifdef DEBUG_CONSOLE
            debug_serial->puts("Check if the device is properly closed");
#endif
        }
        //if(sensor_open != 0)//simulates that the door is open for 3 seconds
        //{
        //    sensor_open--;
        //    wait(1);
        //}
    }
}