#include "mbed.h"
#include "HCSR04.h"
#include "RN41/RN41.h"
#include "ble/BLE.h"
#include "ble/Gap.h"
#include <string>

#define MIN_DISTANCE 2
#define MAX_DISTANCE 110

Serial pc(USBTX, USBRX, 115200);
HCSR04 sensorVolume(p22, p21);
HCSR04 sensorFreq(p24, p23);
RN41 ble(p9, p10);
float freqValue;
float volumeValue; //0 to 100

void configSystem() {
    //config sensors
    sensorFreq.setRanges(MIN_DISTANCE, MAX_DISTANCE);
    sensorVolume.setRanges(MIN_DISTANCE, MAX_DISTANCE);
    freqValue = 0.0f;
    volumeValue = 0.0f;
    //config BLE
    pc.printf("Hello");
    bool a = ble.setDeviceName("theremin");
    bool b = ble.setAuthenticationMode(0);
    bool c = ble.setMode(4);
    pc.printf("deviceName : %d %d %d", a, b, c);
}

void transformValues() {
    freqValue = freqValue / MAX_DISTANCE;
    volumeValue = (MAX_DISTANCE - volumeValue) / MAX_DISTANCE;
}

float measureSensor(HCSR04 &sensor) {
    sensor.startMeasurement();
    while(!sensor.isNewDataReady());
    return sensor.getDistance_mm();
}

void sendDataBluetooth(string line) {
    //rn41.sendLine(line);
    //pc.printf(rn41.getLine().c_str());
}

int main() {
    configSystem();
    //TODO: Cambiar ranges con bluetooth a través de la app? Se necesitan dos modulos bluetooth, no
    while(true) {
        freqValue = measureSensor(sensorFreq);
        volumeValue = measureSensor(sensorVolume);
        //pc.printf("Frequency: %f mm. Volume: %f mm. \n\r", freqValue, volumeValue);
        transformValues();
        //sendDataBluetooth("foo");
        //pc.printf("getConnectionStatus: " + ble.getConnectionStatus());
        //pc.printf("getConnectionStatus: " + ble.getConnectionStatus());
        //TODO (Manuel): enviar por bluetooth
        //sendBluetooth();
        wait(0.5);
    }
}
