/*
    Multichannel_Gas_GMXXX.h
    Description: A drive for Seeed Grove Multichannel gas sensor V2.0.
    2019 Copyright (c) Seeed Technology Inc.  All right reserved.
    Author: Hongtai Liu(lht856@foxmail.com)
    2019-6-18

    The MIT License (MIT)
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.1  USA
*/
#ifndef __GAS_GMXXX__
#define __GAS_GMXXX__

#include <inttypes.h>
#include "mbed.h"

#define GM_RESOLUTION 1023

//command
#define GM_102B 0x01
#define GM_302B 0x03
//#define GM_402B 0x04
#define GM_502B 0x05
#define GM_702B 0x07
//#define GM_802B 0x08
#define CHANGE_I2C_ADDR 0x55
#define WARMING_UP 0xFE
#define WARMING_DOWN  0xFF

class GAS_GMXXX 
{
    public:
        GAS_GMXXX(PinName sda, PinName scl, uint8_t addr = 0x08);
        void init();
        void setAddress(uint8_t address = 0x08);
        void preheated();
        void unPreheated();
        void changeGMXXXAddr(uint8_t address = 0x08);
        uint32_t measure_NO2()
        {
            return getGM102B();
        };
        uint32_t getGM102B();
        uint32_t measure_C2H5OH()
        {
            return getGM302B();
        };
        uint32_t getGM302B();
        #ifdef GM_402B
        uint32_t getGM402B();
        #endif
        uint32_t measure_VOC()
        {
            return getGM502B();
        };
        uint32_t getGM502B();
        uint32_t measure_CO()
        {
            return getGM702B();
        };
        uint32_t getGM702B();
        #ifdef GM_802B
        uint32_t getGM802B();
        #endif
        inline float calcVol(uint32_t adc) 
        {
            return (adc * 3.3) / GM_RESOLUTION;
        };
        void read();
        bool gas_detected();
        float get_no2();
        float get_c2h5oh();
        float get_voc();
        float get_co();
    private:
        I2C* _i2c_p;
        I2C& _i2c;

        float _no2, _c2h5oh, _voc, _co;

        bool isPreheated;
        bool gasDetected;
        uint8_t GMXXX_ADDRESS;
        void GMXXXWriteByte(uint8_t cmd);
        uint32_t GMXXXRead32();
};
#endif
