#include "mbed.h"
#include "string"
#define UP 0b00000001
#define DOWN 0b00000010
#define HANDR 0b00000100
#define HANDL 0b00001000
#define other 0b00010000
#define INT_TIME 0.02

RawSerial pc (USBTX, USBRX,115200);
RawSerial Slave (p28,p27,115200);
RawSerial saber1(p13,p14,115200);


DigitalOut Ben1(p23); // 電磁弁
DigitalOut Ben2(p24); //電磁弁
DigitalOut LSwitch(p26); //リミットスイッチ
DigitalIn DS1(p28); //モーター
DigitalIn DS2(p27); //モーター
DigitalOut ledG(p17); //LEDgreen
DigitalOut ledR(p20); //LEDred
Ticker timer;

string Slave_str = "";
string pc_str = "";

int speed;
int muki;

char _c = 0b00000000;

void Slave_recv()
{
    pc.printf("!");
    char Slave_c = Slave.getc();
    Slave_str += Slave_c;
    if(Slave_c == '\n') {
        _c = Slave_str[0];
        pc_str = Slave_str;
        Slave_str = "";
        pc.printf(",!!");
    }

}

void timer_interrupt()
{

    //Slave.printf("Comm_Slave\n");
    pc.printf(pc_str.c_str());
    pc.printf(",!!!");

}
int main()
{
    timer.attach(&timer_interrupt,INT_TIME);

    Slave.attach(&Slave_recv,RawSerial::RxIrq);

    while(1) {

        if(_c & UP) {
            muki = 1;
            speed = 100;

            saber1.putc(132);
            saber1.putc(muki);
            saber1.putc(speed);
            saber1.putc( ( 132 + muki + speed ) & 127 );

        }
        if(_c & DOWN ) {
            muki = 0;
            speed = 100;

            saber1.putc(132);
            saber1.putc(muki);
            saber1.putc(speed);
            saber1.putc( ( 132 + muki + speed ) & 127 );

        }


        if(_c & HANDR ) {
            Ben1 = 1;
            ledR = 1;
            wait(0.1);


        }

        if(_c & HANDL ) {
            Ben2 = 1;
            ledG = 1;
            wait(0.1);


        } else {
            int count = 0;
            if(_c & HANDR  || _c & HA; ^NDL ) {
                count = count + 1;//countに1を足す
                wait(0.1);
            }

        }
    }


}