#pragma once 
#include "mbed.h"
#include "ov7670reg.h"

#define OV7670_WRITE (0x42)
#define OV7670_READ  (0x43)
#define OV7670_WRITEWAIT (20)
#define OV7670_NOACK (0)
#define OV7670_REGMAX (201)
#define OV7670_I2CFREQ (100000)


//
// OV7670 + FIFO AL422B camera board test
//
class OV7670 
{
    
public:  
OV7670(
        PinName sda,// Camera I2C port
        PinName scl,// Camera I2C port
        PinName vs, // VSYNC
        PinName hr, // HREF
        PinName we, // WEN
        PortName port, // 8bit bus port
        int mask, // 0b0000_0M65_4000_0321_L000_0000_0000_0000 = 0x07878000
        PinName rt, // /RRST
        PinName o,  // /OE
        PinName rc  // RCLK      
        ) ;
        
                 ~OV7670();

        void CaptureNext(void);
        bool CaptureDone(void);
            void WriteReg(int addr,char data);
        void Reset(void);
        void test(void);
        void InitQQVGA(int SIZEX);
            char ReadReg(int addr);
    int ReadOneByte(void);
    int ReadOneWord(void);
    void ReadStart(void);
    void ReadStop(void);
    void VsyncHandler(void);
          

private:
    I2C camera ;
    InterruptIn vsync;
    DigitalIn href;
    DigitalOut wen ;
    PortIn dataP;
    DigitalOut rrst,oe,rclk ;
            volatile int LineCounter;
        volatile int LastLines;
        volatile bool CaptureReq;
        volatile bool Busy;
        volatile bool Done; 
        char *format_temp;
    };
