//
// OV7670 + FIFO AL422B camera board test
//
#include "mbed.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "OV7670.h"
#include "FastPWM.h"

#define SIZEX 320
#define SIZEY 240

OV7670 camera(
              D14,D15,       // SDA,SCL(I2C / SCCB)
              //    PortC,0x160,   // VSYNC,HREF,pclk   ->  PC_5,PC_6,PC_8
              PortA,0x000000E0,   // VSYNC,HREF,pclk   ->  PA_7,PA_6,PA_5
              PortB,0x0000E03E); //D7-D0: PB_15, PB_14, PB_13, PB_5, PB_4, PB_3, PB_2, PB_1

FastPWM xclk(D7);

Serial pc(USBTX,USBRX);
//Timer tempo;
DigitalOut led(D10);

double freq;


void flushSerial(void) { char char1 = 0; while (pc.readable()) { char1 = pc.getc(); } return; }


int main() {

    int k=0, rb=0, c, i;

    xclk.period(0.5e-7);    //MAGIC VALUE 0.5e-7
    xclk.write(0.5);
    
    pc.baud(921600);
    
    uint8_t bank[76801];
    
    for(i=0;i<76801;i++) bank[i]=0;
    
    double fr=12000000.0;
    const char *temp="START";
    
    wait(0.05);
    
    camera.Reset(fr) ;
    
    int cnt=0;
    char data1[OV7670_REGMAX],data2[OV7670_REGMAX];
    
    for (i=0;i<OV7670_REGMAX;i++)
    {
        data1[i]=camera.ReadReg(i); // READ REG
        //                 if ((i & 0x0F) == 0) pc.printf("\r\n%02X : ",i);
        //    pc.printf("Addr %02X = %02X ,",i,data1[i]);
    }
    camera.Init(0,SIZEX) ;
    
    for (i=0;i<OV7670_REGMAX;i++)
    {
        //   data2[i]=camera.ReadReg(i); // READ REG
        //                 pc.printf("data2= %02X\n",data2[i]);
        // if ((i & 0x0F) == 0) pc.printf("\r\n%02X : ",i);
        //         if(data1[i]!=data2[i]) pc.printf("CHANGED %02X = %02X/%02X ,",i,data1[i],data2[i]);
    }
    
    wait(0.1);
    
    //  tempo.start();
    int j=0,idx=0,index=0;
    //   float time, t0;
    
    uint8_t ss, sss;
    
    led=0;
    
    // camera.shot(SIZEX,SIZEY,bank);
    
    while(1){
        
        /*
         time=tempo.read();
         if(j==0) t0=time;
         time-=t0;
         //   printf("\n%f\n",time);
         
         if(time>2.0) {
         tempo.stop();
         t0=tempo.read();
         //     printf("%f  Iteration n. %d, Freq= %.9f\n",time,i,1.0/freq);
         //  i+=5;
         i+=0x01;
         }
         
         if(i>0x8f)    i=0x0;
        */
        
      //  pc.abort_write();
         flushSerial();
       //  pc.send_break();        
        
        
        char str[25], test[25];
        for (int g=0;g<25;g++) str[g]=0;
        uint8_t reg,dat;
        
        uint8_t buf=pc.getc();
        k=0;
        str[k]=buf;
       
       
        while(str[k]!='\n'){
            k++;
            str[k]=pc.getc();
        }
                
        pc.printf("ECHO %s\n",str);
        if(sscanf(str,"R_%d,%u",&reg,&dat)!=0) {
            camera.WriteReg((int)reg,dat);
                     pc.printf("ECHO REGACK\n");
        }
        
        if(sscanf(str,"I_%d",&reg)!=0) {
            camera.Init2();
                     pc.printf("ECHO INTACK\n");
        }
        
       int  n=0;
        for(i=0;i<k;i++){
        if (str[i]==temp[i]) n++;
        }

        if(n==(strlen(temp))){
               //  pc.printf("ECHO FOUND\n");
         
         camera.shot(SIZEX,SIZEY,bank);
         c=0;
       
         pc.printf("FrameStart\n");
         for(j=0;j<SIZEY;j++){
         for(i=0;i<SIZEX;i++)  {
         pc.printf("%d ",bank[c]);
         wait_us(40);
         c++;
         }
         pc.printf("\n");
         }
                  wait_ms(250);
         pc.printf("FrameEnd\n");
        
}
        led=!led;
        
    }
}