#pragma once 
#include "mbed.h"
#include "OV7670reg.h"
//
// OV7670 

class OV7670 
{
public:

volatile int LineCounter ;
    volatile int LastLines ;
    volatile bool CaptureReq ;
    volatile bool Busy ;
    volatile bool Done ;  
    volatile int PixCounter;
        void CaptureNext(void);
        bool CaptureDone(void);
            void WriteReg(int addr,char data);
        void Reset(float frequ);
        void test(void);
        void Init(float frequ,int sizeX);
        void Init2(void);
     char ReadReg(int addr);
    uint8_t ReadOneByte(void);
    int ReadOneWord(void);
    void ReadStart(void);
    void ReadStop(void);
    void VsyncHandler(void);
    void HrefHandler(void);
    void PclkHandler(void) ;
    void wait_posedge(InterruptIn pin);
    void wait_negedge(InterruptIn pin);
    void shot(int sizeX, int sizeY,uint8_t *bank0);
    
    OV7670(
        PinName sda,// Camera I2C port
        PinName scl,// Camera I2C port
        /*
        PinName vs, // VSYNC
        PinName hr, // HREF
        PinName pic ,// /pclk
        */
        PortName ports, // 8bit bus port
        int masks,
        PortName port, // 8bit bus port
        int mask
    ) : camera(sda,scl),sync(ports,masks),dataP(port,mask)

    {


       
        camera.stop() ;
       camera.frequency(OV7670_I2CFREQ) ;
       // vsync.fall(this,&OV7670::VsyncHandler) ;
       // href.rise(callback(this, &OV7670::HrefHandler)) ;
      // pclk.rise(this,&OV7670::PclkHandler) ; // ????????????? blocca tutto il programma
        CaptureReq = false ;
        Busy = false ;
        Done = false ;
        LineCounter = 0 ;
        camera.start();
    }
    protected:
        I2C camera ;
    //InterruptIn vsync,href,pclk;
    PortIn sync;
    /*
    DigitalIn vsync;
    DigitalIn href;
     DigitalIn pclk;
    */
    PortIn dataP;
        };