#include "mbed.h"
#include "OV7670reg.h"
#include "OV7670.h"

    void OV7670::CaptureNext(void) {
        CaptureReq = true ;
        Busy = true ;
    }

    bool OV7670::CaptureDone(void) {
        bool result ;
        if (Busy) {
            result = false ;
        } else {
            result = Done ;
            Done = false ;
        }
        return result ;
    }

    void OV7670::WriteReg(int addr,char data) {
        camera.frequency(OV7670_I2CFREQ);
        camera.start() ;
        camera.write(OV7670_WRITE) ;
        wait_us(OV7670_WRITEWAIT);
        camera.write(addr) ;
        wait_us(OV7670_WRITEWAIT);
        camera.write(data) ;
        camera.stop() ;
        wait_us(10);
    }

    char OV7670::ReadReg(int addr) {
        int data ;
        camera.frequency(OV7670_I2CFREQ);
        camera.start() ;
        camera.write(OV7670_WRITE) ;
        wait_us(OV7670_WRITEWAIT);
        camera.write(addr) ;
        camera.stop() ;
        wait_us(OV7670_WRITEWAIT);
        camera.start() ;
        camera.write(OV7670_READ) ;
        wait_us(OV7670_WRITEWAIT);
        data = camera.read(OV7670_NOACK) ;
        camera.stop() ;
        wait_us(10);
        return data ;
    }

    void OV7670::Reset(float frequ) {

         wait_ms(200) ;
        WriteReg(0x12,0xa4) ; // RESET CAMERA
        wait_ms(200) ;
    }

void OV7670::Init2(void){
        
    int hstart = 456, hstop = 24, vstart = 14, vstop = 494;
    unsigned char v;
    
    WriteReg(REG_COM7, COM7_RESET); /* reset to default values */
    WriteReg(REG_CLKRC, 0x01);
    WriteReg(REG_COM7, 0x10); /* output format: YUCV */

    WriteReg(REG_HSTART, (hstart >> 3) & 0xff);
    WriteReg(REG_HSTOP, (hstop >> 3) & 0xff);
    v = ReadReg(REG_HREF);
    v = (v & 0xc0) | ((hstop & 0x7) << 3) | (hstart & 0x7);
    WriteReg(REG_HREF, v);

    WriteReg(REG_VSTART, (vstart >> 2) & 0xff);
    WriteReg(REG_VSTOP, (vstop >> 2) & 0xff);
    v = ReadReg(REG_VREF);
    v = (v & 0xf0) | ((vstop & 0x3) << 2) | (vstart & 0x3);
    WriteReg(REG_VREF, v);

    WriteReg(REG_COM3, COM3_SCALEEN | COM3_DCWEN);
    WriteReg(REG_COM14, COM14_DCWEN | 0x01);
    WriteReg(0x73, 0xf1);
    WriteReg(0xa2, 0x52);
    WriteReg(0x7b, 0x1c);
    WriteReg(0x7c, 0x28);
    WriteReg(0x7d, 0x3c);
    WriteReg(0x7f, 0x69);
    WriteReg(REG_COM9, 0x38);
    WriteReg(0xa1, 0x0b);
    WriteReg(0x74, 0x19);
    WriteReg(0x9a, 0x80);
    WriteReg(0x43, 0x14);
    WriteReg(REG_COM13, 0xc0);
    WriteReg(0x70, 0x3A);
    WriteReg(0x71, 0x35);
    WriteReg(0x72, 0x11);

    /* Gamma curve values */
    WriteReg(0x7a, 0x20);
    WriteReg(0x7b, 0x10);
    WriteReg(0x7c, 0x1e);
    WriteReg(0x7d, 0x35);
    WriteReg(0x7e, 0x5a);
    WriteReg(0x7f, 0x69);
    WriteReg(0x80, 0x76);
    WriteReg(0x81, 0x80);
    WriteReg(0x82, 0x88);
    WriteReg(0x83, 0x8f);
    WriteReg(0x84, 0x96);
    WriteReg(0x85, 0xa3);
    WriteReg(0x86, 0xaf);
    WriteReg(0x87, 0xc4);
    WriteReg(0x88, 0xd7);
    WriteReg(0x89, 0xe8);

    /* AGC and AEC parameters.  Note we start by disabling those features,
     then turn them only after tweaking the values. */
    WriteReg(REG_COM8, COM8_FASTAEC | COM8_AECSTEP | COM8_BFILT);
    WriteReg(REG_GAIN, 0);
    WriteReg(REG_AECH, 0);
    WriteReg(REG_COM4, 0x40); /* magic reserved bit */
    WriteReg(REG_COM9, 0x18); /* 4x gain + magic rsvd bit */
    WriteReg(REG_BD50MAX, 0x05);
    WriteReg(REG_BD60MAX, 0x07);
    WriteReg(REG_AEW, 0x95);
    WriteReg(REG_AEB, 0x33);
    WriteReg(REG_VPT, 0xe3);
    WriteReg(REG_HAECC1, 0x78);
    WriteReg(REG_HAECC2, 0x68);
    WriteReg(0xa1, 0x03); /* magic */
    WriteReg(REG_HAECC3, 0xd8);
    WriteReg(REG_HAECC4, 0xd8);
    WriteReg(REG_HAECC5, 0xf0);
    WriteReg(REG_HAECC6, 0x90);
    WriteReg(REG_HAECC7, 0x94);
    WriteReg(REG_COM8,
            COM8_FASTAEC | COM8_AECSTEP | COM8_BFILT | COM8_AGC | COM8_AEC);

    /* Almost all of these are magic "reserved" values.  */
    WriteReg(REG_COM5, 0x61);
    WriteReg(REG_COM6, 0x4b);
    WriteReg(0x16, 0x02);
    WriteReg(REG_MVFP, 0x07);
    WriteReg(0x21, 0x02);
    WriteReg(0x22, 0x91);
    WriteReg(0x29, 0x07);
    WriteReg(0x33, 0x0b);
    WriteReg(0x35, 0x0b);
    WriteReg(0x37, 0x1d);
    WriteReg(0x38, 0x71);
    WriteReg(0x39, 0x2a);
    WriteReg(REG_COM12, 0x78);
    WriteReg(0x4d, 0x40);
    WriteReg(0x4e, 0x20);
    WriteReg(REG_GFIX, 0);
    WriteReg(0x6b, 0x4a);
    WriteReg(0x74, 0x10);
    WriteReg(0x8d, 0x4f);
    WriteReg(0x8e, 0);
    WriteReg(0x8f, 0);
    WriteReg(0x90, 0);
    WriteReg(0x91, 0);
    WriteReg(0x96, 0);
    WriteReg(0x9a, 0);
    WriteReg(0xb0, 0x84);
    WriteReg(0xb1, 0x0c);
    WriteReg(0xb2, 0x0e);
    WriteReg(0xb3, 0x82);
    WriteReg(0xb8, 0x0a);

    /* Matrix coefficients */
    WriteReg(0x4f, 0x80);
    WriteReg(0x50, 0x80);
    WriteReg(0x51, 0);
    WriteReg(0x52, 0x22);
    WriteReg(0x53, 0x5e);
    WriteReg(0x54, 0x80);
    WriteReg(0x58, 0x9e);

    /* More reserved magic, some of which tweaks white balance */
    WriteReg(0x43, 0x0a);
    WriteReg(0x44, 0xf0);
    WriteReg(0x45, 0x34);
    WriteReg(0x46, 0x58);
    WriteReg(0x47, 0x28);
    WriteReg(0x48, 0x3a);
    WriteReg(0x59, 0x88);
    WriteReg(0x5a, 0x88);
    WriteReg(0x5b, 0x44);
    WriteReg(0x5c, 0x67);
    WriteReg(0x5d, 0x49);
    WriteReg(0x5e, 0x0e);
    WriteReg(0x6c, 0x0a);
    WriteReg(0x6d, 0x55);
    WriteReg(0x6e, 0x11);
    WriteReg(0x6f, 0x9f); /* "9e for advance AWB" */
    WriteReg(0x6a, 0x40);
    WriteReg(REG_BLUE, 0x40);
    WriteReg(REG_RED, 0x60);
    WriteReg(REG_COM8,
            COM8_FASTAEC | COM8_AECSTEP | COM8_BFILT | COM8_AGC | COM8_AEC
                    | COM8_AWB);
    }

    void OV7670::Init(float frequ,int sizeX) {
             sync.mode(OpenDrain);
             dataP.mode(PullDown);
           //  printf("point 3\n");
    Reset(0.0);
     Reset(0.0);
    //if(sizeX==320) {
  // WriteReg(DBLV, 0xaa);                    // bypass PLL
    //WriteReg(REG_CLKRC,0x0c);//0x8c
    WriteReg(REG_TSLB,0x0c);//0x80
 
  /*
    WriteReg(SCALING_XSC, 0x4a);
    WriteReg(SCALING_YSC, 0x35);
    WriteReg(REG_HREF, 0xa4);
    WriteReg(REG_HSTART, 168);
    WriteReg(REG_HSTOP, 24);
    WriteReg(REG_VREF, 0x0a);
    WriteReg(REG_VSTART,12);
    WriteReg(REG_VSTOP, 492);
  */
  
    //WriteReg(REG_HREF, 0xc0);    
         WriteReg(REG_CLKRC,0x1c) ;//OCCHIO
         WriteReg(REG_COM10,0x20) ;
        WriteReg(REG_COM1,0x0) ;
        WriteReg(REG_COM6,0xc3) ;
        WriteReg(REG_COM7,0x14) ;
        WriteReg(REG_COM9,0x48) ;
        WriteReg(REG_RGB444,0x0) ;

        WriteReg(REG_COM17,0x00) ;
        WriteReg(REG_COM3,0x04) ;
      //  WriteReg(REG_COM14, 0x19);//OCCHIO
        WriteReg(REG_COM15, 0xc0);
       WriteReg(REG_COM2, 0x03);
   //     WriteReg(SCALING_DCWCTR,0x11);
     //   WriteReg(SCALING_PCLK_DIV,0xf2);//OCCHIO
       // WriteReg(SCALING_PCLK_DELAY,0x02);
    WriteReg(REG_COM8,0xc7) ;
    WriteReg(REG_COM11,0x0a) ;//1A //0x90
    WriteReg(REG_COM13, 0xc1);//0x88
    WriteReg(REG_EDGE,0x04) ;
    WriteReg(REG_PSHFT,0x0) ;

        
        WriteReg(0x7a, 0x20);
        WriteReg(0x7b, 0x1c);
        WriteReg(0x7c, 0x28);
        WriteReg(0x7d, 0x3c);
        WriteReg(0x7e, 0x55);
        WriteReg(0x7f, 0x68);
        WriteReg(0x80, 0x76);
        WriteReg(0x81, 0x80);
        WriteReg(0x82, 0x88);
        WriteReg(0x83, 0x8f);
        WriteReg(0x84, 0x96);
        WriteReg(0x85, 0xa3);
        WriteReg(0x86, 0xaf);
        WriteReg(0x87, 0xc4);
        WriteReg(0x88, 0xd7);
        WriteReg(0x89, 0xe8);
        
        WriteReg(0x13, 0xe0);
        WriteReg(0x00, 0x00);
        WriteReg(0x10, 0x00);
        WriteReg(0x0d, 0x00);
        WriteReg(0x14, 0x28);
        WriteReg(0xa5, 0x05);
        WriteReg(0xab, 0x07);
        WriteReg(0x24, 0x75);
        WriteReg(0x25, 0x63);
        WriteReg(0x26, 0xA5);
        WriteReg(0x9f, 0x78);
        WriteReg(0xa0, 0x68);
        WriteReg(0xa1, 0x03);
        WriteReg(0xa6, 0xdf);
        WriteReg(0xa7, 0xdf);
        WriteReg(0xa8, 0xf0);
        WriteReg(0xa9, 0x90);
        WriteReg(0xaa, 0x94);      
        WriteReg(0x13, 0xe5);
        
        WriteReg(0x0e, 0x61);
        WriteReg(0x0f, 0x4b);
        WriteReg(0x16, 0x02);
        WriteReg(0x21, 0x02);
        WriteReg(0x22, 0x91);
        WriteReg(0x29, 0x07);
        WriteReg(0x33, 0x0b);
        WriteReg(0x35, 0x0b);
        WriteReg(0x37, 0x1d);
        WriteReg(0x38, 0x71);
        WriteReg(0x39, 0x2a);
        WriteReg(0x3c, 0x78);
        WriteReg(0x4d, 0x40);
        WriteReg(0x4e, 0x20);
        WriteReg(0x69, 0x00);
        WriteReg(0x6b, 0x00);
        WriteReg(0x74, 0x19);
        WriteReg(0x8d, 0x4f);
        WriteReg(0x8e, 0x00);
        WriteReg(0x8f, 0x00);
        WriteReg(0x90, 0x00);
        WriteReg(0x91, 0x00);
        WriteReg(0x92, 0x00);
        WriteReg(0x96, 0x00);
        WriteReg(0x9a, 0x80);
        WriteReg(0xb0, 0x84);
        WriteReg(0xb1, 0x0c);
        WriteReg(0xb2, 0x0e);
        WriteReg(0xb3, 0x82);
        WriteReg(0xb8, 0x0a);
        WriteReg(0x43, 0x14);
        WriteReg(0x44, 0xf0);
        WriteReg(0x45, 0x34);
        WriteReg(0x46, 0x58);
        WriteReg(0x47, 0x28);
        WriteReg(0x48, 0x3a);
        WriteReg(0x59, 0x88);
        WriteReg(0x5a, 0x88);
        WriteReg(0x5b, 0x44);
        WriteReg(0x5c, 0x67);
        WriteReg(0x5d, 0x49);
        WriteReg(0x5e, 0x0e);
        WriteReg(0x64, 0x04);
        WriteReg(0x65, 0x20);
        WriteReg(0x66, 0x05);
        WriteReg(0x94, 0x04);
        WriteReg(0x95, 0x08);
        WriteReg(0x6c, 0x0a);
        WriteReg(0x6d, 0x55);
        WriteReg(0x6e, 0x11);
        WriteReg(0x6f, 0x9f);
        WriteReg(0x6a, 0x40);
        WriteReg(0x01, 0x40);
        WriteReg(0x02, 0x40);
        WriteReg(0x13, 0xe7);
        WriteReg(0x15, 0x02);
        WriteReg(0x4f, 0x80);
        WriteReg(0x50, 0x80);
        WriteReg(0x51, 0x00);
        WriteReg(0x52, 0x22);
        WriteReg(0x53, 0x5e);
        WriteReg(0x54, 0x80);
        WriteReg(0x58, 0x9e);   
        WriteReg(0x41, 0x08);
        WriteReg(0x3f, 0x00);
        WriteReg(0x75, 0x05);
        WriteReg(0x76, 0xe1);
        WriteReg(0x4c, 0x00);
        WriteReg(0x77, 0x01);
        WriteReg(0x3d, 0xc2);  
        WriteReg(0x4b, 0x09);
        WriteReg(0xc9, 0x60);
        WriteReg(0x41, 0x38);
        WriteReg(0x56, 0x40);
        WriteReg(0x34, 0x11);
        WriteReg(0x3b, 0x02);
        WriteReg(0xa4, 0x89);
        WriteReg(0x96, 0x00);
        WriteReg(0x97, 0x30);
        WriteReg(0x98, 0x20);
        WriteReg(0x99, 0x30);
        WriteReg(0x9a, 0x84);
        WriteReg(0x9b, 0x29);
        WriteReg(0x9c, 0x03);
        WriteReg(0x9d, 0x4c);
        WriteReg(0x9e, 0x3f);
        WriteReg(0x78, 0x04);   
        WriteReg(0x79, 0x01);
        WriteReg(0xc8, 0xf0);
        WriteReg(0x79, 0x0f);
        WriteReg(0xc8, 0x00);
        WriteReg(0x79, 0x10);
        WriteReg(0xc8, 0x7e);
        WriteReg(0x79, 0x0a);
        WriteReg(0xc8, 0x80);
        WriteReg(0x79, 0x0b);
        WriteReg(0xc8, 0x01);
        WriteReg(0x79, 0x0c);
        WriteReg(0xc8, 0x0f);
        WriteReg(0x79, 0x0d);
        WriteReg(0xc8, 0x20);
        WriteReg(0x79, 0x09);
        WriteReg(0xc8, 0x80);
        WriteReg(0x79, 0x02);
        WriteReg(0xc8, 0xc0);
        WriteReg(0x79, 0x03);
        WriteReg(0xc8, 0x40);
        WriteReg(0x79, 0x05);
        WriteReg(0xc8, 0x30);
        WriteReg(0x79, 0x26);
        WriteReg(0x09, 0x03);
        WriteReg(0x3b, 0x42);
   // }
        WriteReg(0xff, 0xff);   /* END MARKER */ 
               
       // printf("Init\n");
    }

    // vsync handler
    void OV7670::VsyncHandler(void) {
    }


    // href handler
    void OV7670::HrefHandler(void) {
        LineCounter++;
    }    
    
    // pclk handler
    void OV7670::PclkHandler(void) {
        PixCounter++ ;
    }

    void OV7670::wait_posedge(InterruptIn pin) {
        while(pin);
        while(!pin);
        while(pin){
}
    }

    void OV7670::wait_negedge(InterruptIn pin) {
        while(!pin);
        while(pin) ;
    }

    uint8_t OV7670::ReadOneByte(void) {
       int data= dataP.read();
       uint8_t result=(uint8_t)(((data&0x3E)>>1)|((data&0xE000)>>8));
        return result ;
    }

//    void OV7670::shot(int sizeX, int sizeY, uint8_t *bank0) {
    void OV7670::shot(int sizeX, int sizeY,uint8_t *bank0) {

//uint8_t bank0[76800];

     uint8_t b1,b2;
        int x = 0,pix=0; // col
        int y = 0,line=0; // row
        int n = 0; //  px number
        uint8_t r,g,b;
        int colour;
        int i=0,j;
    int test=sync.read();

uint8_t vsync=(test&0x80)>>7;
uint8_t href=(test&0x40)>>6;
uint8_t pclk=(test&0x20)>>5;
 //printf("sync= %d,  v,h,p =  %d , %d, %d  sizeX= %d\n",test, vsync,href,pclk,sizeX);
      
      //  printf("FrameStart\n");
        
       while(vsync==0){
            test=sync.read();
            vsync=(test&0x80)>>7;
            }        
          while(vsync==1){
            test=sync.read();
            vsync=(test&0x80)>>7;
            }  

       n=0;
            
   for ( y=0; y<sizeY; y++){
x=0;
         
        while (href==0){
            test=sync.read();
            href=(test&0x40)>>6;
            }  

        for ( x=0; x<sizeX; x++){           
           
            while (pclk==0){
            test=sync.read();
            pclk=(test&0x20)>>5;
            } 
                        
                  b1=ReadOneByte(); 
  
            while(pclk==1){
            test=sync.read();
          pclk=(test&0x20)>>5;
            } 
                 
     
         while(pclk==0){
            test=sync.read();
            pclk=(test&0x20)>>5;
            } 
            
                     b2=ReadOneByte();

           while (pclk==1){
            test=sync.read();
            pclk=(test&0x20)>>5;
            } 
                            
               r=((b1>>3) & 0x1f) ;
            g= ((((b1&0x07)<<3) &0x3f) | ((b2&0xe0) >>5))<<2;
             b=(b2 & 0xf8) >>3;
       //colour=(((int)b1)<<8)|((int)b2);
     //    printf("%u ",r); //ACTION!!!
//         printf("%u_u ",b1,b2); //ACTION!!!
            bank0[n] =b;
                n++;
               // x++;
        }
        
   //     }
       // y++;
     //  printf("\n");
/*
   if (href==1){ 
                while (href==1){
            test=sync.read();
            href=(test&0x40)>>6;
            }  
            }*/
                        test=sync.read();
            href=(test&0x40)>>6;
}

   //  printf("FrameEnd\n");
//printf("            PIXELS= %d",n);

i=0;
int c=0;

/*     for(j=0;j<sizeY;j++){
               for(i=0;i<sizeX;i++)  {
                    printf("%u ",bank0[c]);
//                    wait_us(100);
                    c++;
                }
                printf("\n");
                }
                printf("FrameEnd\n");
 */
                
    }// SHOT
