#include "mbed.h"
#include "ov7670reg.h"

#define OV7670_WRITE (0x42)
#define OV7670_READ  (0x43)
#define OV7670_WRITEWAIT (20)
#define OV7670_NOACK (0)
#define OV7670_REGMAX (201)
#define OV7670_I2CFREQ (50000)


//
// OV7670 + FIFO AL422B camera board test
//
class OV7670 
{
    
public:  
volatile int LineCounter ;
    volatile int LastLines ;
    volatile bool CaptureReq ;
    volatile bool Busy ;
    volatile bool Done ;  
        void CaptureNext(void);
        bool CaptureDone(void);
            void WriteReg(int addr,char data);
        void Reset(void);
        void test(void);
        void InitQQVGA(void);
            char ReadReg(int addr);
    int ReadOneByte(void);
    void ReadStart(void);
    void ReadStop(void);
    void VsyncHandler(void);
    InterruptIn vsync;

    OV7670(
        PinName sda,// Camera I2C port
        PinName scl,// Camera I2C port
        PinName vs, // VSYNC
        PinName hr, // HREF
        PinName we, // WEN
        PortName port, // 8bit bus port
        int mask, // 0b0000_0M65_4000_0321_L000_0000_0000_0000 = 0x07878000
        PinName rt, // /RRST
        PinName o,  // /OE
        PinName rc  // RCLK      
        ) : camera(sda,scl),vsync(vs),href(hr),wen(we),dataP(port,mask),rrst(rt),oe(o),rclk(rc)
    {
        //camera.stop() ;
        camera.frequency(OV7670_I2CFREQ) ;
      //  camera.start() ;

        CaptureReq = false ;
        Busy = false ;
        Done = false ;
        LineCounter = 0 ;
        rrst = 1 ;
        oe = 1 ;
        rclk = 1 ;
        wen = 0 ;
             vsync.rise(this,&OV7670::VsyncHandler) ;
    }
protected:
    I2C camera ;
    DigitalIn href;
    DigitalOut wen ;
    PortIn dataP;
    DigitalOut rrst,oe,rclk ;
    };
