#include "mbed.h"
#include "ov7670reg.h"
#include "OV7670.h"

 // capture request
    void OV7670::CaptureNext(void)
    {
        CaptureReq = true ;
        Busy = true ;
        printf("CaptReq\n");
    }
    
    // capture done? (with clear)
    bool OV7670::CaptureDone(void)
    {
        bool result ;
        if (Busy) {
            result = false ;
        } else {
            result = Done ;
            Done = false ;
        }
        return result ;
    }

    // write to camera
    void OV7670::WriteReg(int addr,char data)
    {
        // WRITE 0x42,ADDR,DATA
        //camera.write(OV7670_WRITE,d1,2) ;
        camera.start() ;
        camera.write(OV7670_WRITE) ;
        wait_us(OV7670_WRITEWAIT);
        camera.write(addr) ;
        wait_us(OV7670_WRITEWAIT);
        camera.write(data) ;
        camera.stop() ;
    }

    // read from camera
    char OV7670::ReadReg(int addr)
    {
 /*
 char buff[20];
 char buf[20];
    buff[0] = addr;
    buff[1] = OV7670_NOACK;

    camera.write(OV7670_WRITE,buff,1);
    camera.read(OV7670_WRITE+1,buf,1);
    return buf[0];*/
    int data ;

        // WRITE 0x42,ADDR
        camera.start() ;
        camera.write(OV7670_WRITE) ;
        wait_us(OV7670_WRITEWAIT);
        camera.write(addr) ;
        camera.stop() ;
        wait_us(OV7670_WRITEWAIT);    

        // WRITE 0x43,READ
        camera.start() ;
        camera.write(OV7670_READ) ;
        wait_us(OV7670_WRITEWAIT);
        data = camera.read(OV7670_NOACK) ;
        camera.stop() ;
    
        return data ;
    }

    void OV7670::test(void) 
    { 
        printf("ResetMAMT\n");   
    }
    
    void OV7670::Reset(void) 
    { 
        WriteReg(0x12,0x80) ; // RESET CAMERA
        wait_ms(200) ;
        printf("Reset\n");
    }
    
    void OV7670::InitQQVGA(void) 
    {
       /*
       //WriteReg(REG_COM7,0x80) ;
        WriteReg(REG_CLKRC,0x80);
        WriteReg(REG_COM11,0x1A) ;
        WriteReg(REG_TSLB,0x04);
        WriteReg(REG_TSLB,0x04);
        WriteReg(REG_COM3,0x04) ;
        WriteReg(REG_COM7,0x07) ;
            WriteReg(REG_COM8,0x87) ;
        //WriteReg(REG_RGB444, 0x00);
        //WriteReg(REG_RGB444, 0x00);     // Disable RGB 444?
        WriteReg(REG_COM15, 0xD0);      // Set RGB 565?
*/

        WriteReg(REG_CLKRC,0x80);
        WriteReg(REG_COM11,0x1A) ;
      //  WriteReg(REG_TSLB,0x04);
        //WriteReg(REG_TSLB,0x04);
        //WriteReg(REG_COM1,0x0) ;        
        WriteReg(REG_COM3,0x04) ;
        WriteReg(REG_COM7,0x04) ;
        WriteReg(REG_COM14, 0x1a);
        WriteReg(SCALING_XSC, 0x3a);
        WriteReg(SCALING_YSC, 0x35);
        WriteReg(SCALING_DCWCTR,0x22);
        WriteReg(SCALING_PCLK_DIV,0xf2);
        WriteReg(SCALING_PCLK_DELAY,0x02);
          WriteReg(REG_COM8,0x87) ;
     //   WriteReg(REG_RGB444, 0x02);
       // WriteReg(REG_RGB444, 0x00);     // Disable RGB 444?
        WriteReg(REG_COM15, 0xD0);      // Set RGB 565?
        
        WriteReg(REG_HSTART,0x16) ;
        WriteReg(REG_HSTOP,0x04) ;
        WriteReg(REG_HREF,0x24) ;
        WriteReg(REG_VSTART,0x02) ;
        WriteReg(REG_VSTOP,0x7a) ;
        WriteReg(REG_VREF,0x0a) ;
        WriteReg(REG_COM10,0x02) ;
        WriteReg(REG_MVFP,0x27) ;

        // COLOR SETTING
        WriteReg(0x4f,0x80);
        WriteReg(0x50,0x80);
        WriteReg(0x51,0x00);
        WriteReg(0x52,0x22);
        WriteReg(0x53,0x5e);
        WriteReg(0x54,0x80);
        WriteReg(0x56,0x40);
        WriteReg(0x58,0x9e);
        WriteReg(0x59,0x88);
        WriteReg(0x5a,0x88);
        WriteReg(0x5b,0x44);
        WriteReg(0x5c,0x67);
        WriteReg(0x5d,0x49);
        WriteReg(0x5e,0x0e);
        WriteReg(0x69,0x00);
        WriteReg(0x6a,0x40);
        WriteReg(0x6b,0x0a);
        WriteReg(0x6c,0x0a);
        WriteReg(0x6d,0x55);
        WriteReg(0x6e,0x11);
        WriteReg(0x6f,0x9f);

        WriteReg(0xb0,0x84);
        //////////
        
        
             
        WriteReg(0x7a, 0x20);
        WriteReg(0x7b, 0x1c);
        WriteReg(0x7c, 0x28);
        WriteReg(0x7d, 0x3c);
        WriteReg(0x7e, 0x5a);
        WriteReg(0x7f, 0x68);
        WriteReg(0x80, 0x76);
        WriteReg(0x81, 0x80);
        WriteReg(0x82, 0x88);
        WriteReg(0x83, 0x8f);
        WriteReg(0x84, 0x96);
        WriteReg(0x85, 0xa3);
        WriteReg(0x86, 0xaf);
        WriteReg(0x87, 0xc4);
        WriteReg(0x88, 0xd7);
        WriteReg(0x89, 0xe8);
        
        WriteReg(0x13, 0xe0);
        WriteReg(0x00, 0x00);
        WriteReg(0x10, 0x00);
        WriteReg(0x0d, 0x40);
        WriteReg(0x14, 0x18);
        WriteReg(0xa5, 0x05);
        WriteReg(0xab, 0x07);
        WriteReg(0x24, 0x95);
        WriteReg(0x25, 0x33);
        WriteReg(0x26, 0xe3);
        WriteReg(0x9f, 0x78);
        WriteReg(0xa0, 0x68);
        WriteReg(0xa1, 0x03);
        WriteReg(0xa6, 0xd8);
        WriteReg(0xa7, 0xd8);
        WriteReg(0xa8, 0xf0);
        WriteReg(0xa9, 0x90);
        WriteReg(0xaa, 0x94);
        WriteReg(0x13, 0xe5);
        
        WriteReg(0x0e, 0x61);
        WriteReg(0x0f, 0x4b);
        WriteReg(0x16, 0x02);

        WriteReg(0x21, 0x02);
        WriteReg(0x22, 0x91);
        WriteReg(0x29, 0x07);
        WriteReg(0x33, 0x0b);
        WriteReg(0x35, 0x0b);
        WriteReg(0x37, 0x1d);
        WriteReg(0x38, 0x71);
        WriteReg(0x39, 0x2a);
        WriteReg(0x3c, 0x78);
        WriteReg(0x4d, 0x40);
        WriteReg(0x4e, 0x20);
        WriteReg(0x69, 0x00);

        WriteReg(0x74, 0x10);
        WriteReg(0x8d, 0x4f);
        WriteReg(0x8e, 0x00);
        WriteReg(0x8f, 0x00);
        WriteReg(0x90, 0x00);
        WriteReg(0x91, 0x00);
        WriteReg(0x92, 0x00);

        WriteReg(0x96, 0x00);
        WriteReg(0x9a, 0x80);
        WriteReg(0xb0, 0x84);
        WriteReg(0xb1, 0x0c);
        WriteReg(0xb2, 0x0e);
        WriteReg(0xb3, 0x82);
        WriteReg(0xb8, 0x0a);
        
        WriteReg(0x43, 0x0a);
        WriteReg(0x44, 0xf0);
        WriteReg(0x45, 0x34);
        WriteReg(0x46, 0x58);
        WriteReg(0x47, 0x28);
        WriteReg(0x48, 0x3a);
        WriteReg(0x59, 0x88);
        WriteReg(0x5a, 0x88);
        WriteReg(0x5b, 0x44);
        WriteReg(0x5c, 0x67);
        WriteReg(0x5d, 0x49);
        WriteReg(0x5e, 0x0e);
        WriteReg(0x64, 0x04);
        WriteReg(0x65, 0x20);
        WriteReg(0x66, 0x05);
        WriteReg(0x94, 0x04);
        WriteReg(0x95, 0x08);

        WriteReg(0x6c, 0x0a);
        WriteReg(0x6d, 0x55);
        WriteReg(0x6e, 0x11);
        WriteReg(0x6f, 0x9f);
        WriteReg(0x6a, 0x40);
        WriteReg(0x01, 0x40);
        WriteReg(0x02, 0x40);
        WriteReg(0x13, 0xe7);
        WriteReg(0x15, 0x02);

        WriteReg(0x4f, 0x80);
        WriteReg(0x50, 0x80);
        WriteReg(0x51, 0x00);
        WriteReg(0x52, 0x22);
        WriteReg(0x53, 0x5e);
        WriteReg(0x54, 0x80);
        WriteReg(0x58, 0x9e);
        
        WriteReg(0x41, 0x08);
        WriteReg(0x3f, 0x00);
        WriteReg(0x75, 0x05);
        WriteReg(0x76, 0xe1);
        WriteReg(0x4c, 0x00);
        WriteReg(0x77, 0x01);
        WriteReg(0x3d, 0xc1);
        WriteReg(0x4b, 0x09);
        WriteReg(0xc9, 0x60);
        WriteReg(0x41, 0x38);
        WriteReg(0x56, 0x40);
        
        WriteReg(0x34, 0x11);
        WriteReg(0x3b, 0x02);
        WriteReg(0xa4, 0x88);
        WriteReg(0x96, 0x00);
        WriteReg(0x97, 0x30);
        WriteReg(0x98, 0x20);
        WriteReg(0x99, 0x30);
        WriteReg(0x9a, 0x84);
        WriteReg(0x9b, 0x29);
        WriteReg(0x9c, 0x03);
        WriteReg(0x9d, 0x4c);
        WriteReg(0x9e, 0x3f);
        WriteReg(0x78, 0x04);
        
        WriteReg(0x79, 0x01);
        WriteReg(0xc8, 0xf0);
        WriteReg(0x79, 0x0f);
        WriteReg(0xc8, 0x00);
        WriteReg(0x79, 0x10);
        WriteReg(0xc8, 0x7e);
        WriteReg(0x79, 0x0a);
        WriteReg(0xc8, 0x80);
        WriteReg(0x79, 0x0b);
        WriteReg(0xc8, 0x01);
        WriteReg(0x79, 0x0c);
        WriteReg(0xc8, 0x0f);
        WriteReg(0x79, 0x0d);
        WriteReg(0xc8, 0x20);
        WriteReg(0x79, 0x09);
        WriteReg(0xc8, 0x80);
        WriteReg(0x79, 0x02);
        WriteReg(0xc8, 0xc0);
        WriteReg(0x79, 0x03);
        WriteReg(0xc8, 0x40);
        WriteReg(0x79, 0x05);
        WriteReg(0xc8, 0x30);
        WriteReg(0x79, 0x26);
        WriteReg(0x09, 0x03);
        WriteReg(0x3b, 0x42);
        
        WriteReg(0xff, 0xff);   /* END MARKER */ 
               
        printf("Init\n");
    }    



    // vsync handler
    void OV7670::VsyncHandler(void)
    {
        // Capture Enable
        if (CaptureReq) {
            wen = 1 ;
            Done = false ;
            CaptureReq = false ;
        } else {
            wen = 0 ;
            if (Busy) {
                Busy = false ;
                Done = true ;
            }
        }

        // Hline Counter
        LastLines = LineCounter ;
        LineCounter = 0 ;
    }
    
    
    // Data Read
    int OV7670::ReadOneByte(void)
    {
        int result;
        rclk = 1;
        result = dataP;
/*
        // Shift the bits around to form the byte
        int top = result >> 19;         // Isolate the top nibble
        int middle = result >> 2;       // Isolate bits 2 & 3
        result = result & 0x00000003;   // Isolate bits 0 & 1      
        result += middle;
        result += top;
  */    
    
    //int middle= ((result)& 0xf00)>>4;
    result= ((result&0x0f)|(((result)& 0xf00)>>4))&0xff;
      //  int top=((result&0x01) << 7) | ((result&0x02) << 5) | ((result&0x04) << 3) | ((result&0x08) << 1) | ((result&0x10) >>1) | ((result&0x20) <<3) | ((result&0x40) >>5) | ((result&0x80) >>7);
        int top=((result&0x01) << 7) | ((result&0x02) << 5) | ((result&0x04) << 3) | ((result&0x08) << 1) 
              | ((result&0x10) >>1) | ((result&0x20) <<3) | ((result&0x40) >>5) | ((result&0x80) >>7);
              
        rclk = 0;
        return top;
    }
    
    // Data Start
    void OV7670::ReadStart(void)
    {        
        rrst = 0 ;
        oe = 0 ;
        wait_us(1) ;
        rclk = 0 ;
        wait_us(1) ;
        rclk = 1 ;
        wait_us(1) ;        
        rrst = 1 ;
    }
    
    // Data Stop
    void OV7670::ReadStop(void)
    {
        oe = 1 ;
        ReadOneByte() ;
        rclk = 1 ;
    }