//#ifndef __esp8266_H__
//#define __esp8266_H__

#include "mbed.h"
#include "modem.h"

#define MAX_SOCK_NUM 4 //(0~4)
class esp8266: public Modem
{
public:
    /*Constructor*/
    esp8266(PinName tx,PinName rx,int baudRate,const char *ssid =NULL,const char *password=NULL,const char *host=NULL,const char *port=NULL);
    
    static esp8266* getInstance() {
        return inst;
    };
    //-------------------------------wifi socket----------------------------
    bool join();  // connection au access point  return true false
    
    int connect(int socket); // return  0 success   -1 error
    
    int send(int socket,const char * str,int len);
    
    int recv(char* buf, int len);
    
    bool disconnect(int socket);
    
    bool is_connected();
    
    void reset(); // reset esp8266
    
    void set_sta_ip(char * s_ip);
    void list_ap();
    void getip();
    char _ip[100];
    char _lap[2000];
    //-------------------------------wifi websocket----------------------------
    void websocket(char * url);
    bool w_connect(int socket);
    int w_send(char * str);
    bool w_read(char * message);
    //bool w_is_connected();
    //bool close();
    char* getPath();
    
    //-------------------------------------------------------------------------
    
    
protected:
    
    static esp8266* inst;
    const char* _ssid;
    const char* _password;
    const char* _host;
    const char* _port;
    
private :
    
        //void fillFields(char * url);
        int parseURL(const char* url, char* scheme, size_t maxSchemeLen, char* host, size_t maxHostLen, uint16_t* port, char* path, size_t maxPathLen); //Parse URL
        int sendOpcode(uint8_t opcode, char * msg);
        int sendLength(uint32_t len, char * msg);
        int sendMask(char * msg);
        int readChar(char * pC, bool block = true);
        
        char scheme[8];
        uint16_t port;
        char host[32];
        char path[64];

        int read(char * buf, int len, int min_len = -1);
        int write(char * buf, int len);


};
//#endif