#include "mbed.h"
#include "C12832.h"

C12832 lcd(p5, p7, p6, p8, p11);
InterruptIn joystickcenter(p14);
InterruptIn button(p9);
DigitalOut led(LED1);
DigitalOut flash(LED4);
int i; // variable for flip function.
Timer debounce;// debounce P14

void flip()
{
    if (debounce.read_ms()>200)// if bigger than 1000 want flip 
    led = !led;
    i = 1; 
    debounce.reset(); 
}

int main()
{
    lcd.cls();
    lcd.locate(0,0);
    joystickcenter.rise(&flip);
    debounce.start();
    button.mode(PullUp);
    button.rise(&flip);
    while(1) {
        flash = !flash;
        if( i == 1) {
            lcd.printf("Button pressed");  
        i = 0;
        wait(0.25);
    }
  }
}
