#include "mbed.h"
#include "MODSERIAL.h"
#include "math.h"

//MODSERIAL pc(USBTX, USBRX);
PwmOut Led(D3);
AnalogIn potBright(A0);
Ticker ReadPotmetersTicker;


volatile float DutyCycle;

void ReadPotmeterValues(void)
{
DutyCycle = potBright.read(); 
}


int main()
{
   
    float Frequency = 10000.0; // 10 kHz
    
    ReadPotmetersTicker.attach(ReadPotmeterValues, 0.1); // ask for value potmeter every 100 ms
    
    while (true) 
    {
    Led.period(1/Frequency); // set fixed frequency (high enough so you see an average
    Led.write(DutyCycle); // set duty cycle (ranging from (0.0 = 1.0) 0.0 = 0% and 1.0 = 100%
    wait(0.3f);
    }
}