#include "mbed.h"
#include "math.h"
#include "MODSERIAL.h"
#include "QEI.h"

//Tickers
Ticker TickerMeasureAndControl;
Ticker TickerPrintToScreen;
//Communication
MODSERIAL pc(USBTX,USBRX);
QEI Encoder(D10,D11,NC,32);

//Global pin variables 
PwmOut PwmPin(D5);
DigitalOut DirectionPin(D4);
AnalogIn Potmeter1(A1);
AnalogIn Potmeter2(A0);

//Global variables
volatile bool PrintFlag = false;

//Global variables for printing on screen
volatile float PosRefPrint; // for printing value on screen
volatile float PosMotorPrint; // for printing value on screen
volatile float ErrorPrint;
//-----------------------------------------------------------------------------
//The double-functions

//Get reference position
double GetReferencePosition()
{
// This function set the reference position to determine the position of the signal.
// Reference velocity is set as proportional to duty cycle.
// Positive velocity (if button is pressed) means clockwise(CW) rotation.
    

    
    double ValuePot = Potmeter1.read(); // Read value from potmeter (range from 0-1)
    
        
        double PositionRef = 3*6.2830*ValuePot - 3*3.1415; // position reference ranging from -1.5 rotations till 1.5 rotations
        
        return PositionRef; //rad
}

// actual position of the motor
double GetActualPosition()
{
    //This function determines the actual position of the motor
    //The count:radians relation is 8400:2pi
    double EncoderCounts = Encoder.getPulses();    //number of counts
    double PositionMotor = EncoderCounts/8400*(6.283); // in rad (6.283 = pi)
    
    return PositionMotor;
}



///The controller
double P_Controller(double Error)
{
   double Kp = 35*Potmeter2.read(); // 35 is just a try
   
   double u_k = Kp * Error;
   
   return u_k; //This will become the MotorValue
}

//Ticker function set motorvalues
void SetMotor(double MotorValue)
{
    if (MotorValue >=0)
    {
        DirectionPin = 1;
    }
    else
    {
        DirectionPin = 0;
    }
    
    if (fabs(MotorValue)>1) // if error more than 1 radian, full duty cycle
    {
        PwmPin = 1; 
    }
    else
    {
        PwmPin = fabs(MotorValue);
    }
}

// ----------------------------------------------------------------------------
//Ticker function
void MeasureAndControl(void)
{
    double PositionRef = GetReferencePosition();
    double PositionMotor = GetActualPosition();
    double MotorValue = P_Controller(PositionRef - PositionMotor); // input is error
    SetMotor(MotorValue);
    
    //for printing on screen
    PosRefPrint = PositionRef;
    PosMotorPrint = PositionMotor;
    ErrorPrint = MotorValue;
    
}



void PrintToScreen()
{
    PrintFlag = true;
}


//-----------------------------------------------------------------------------
int main()
{
    pc.baud(115200);
    pc.printf("Hello World\n\r");
    PwmPin.period_us(60); // 16.66667 kHz (default period is too slow!)
    TickerMeasureAndControl.attach(&MeasureAndControl,0.01); //100 Hz
    TickerPrintToScreen.attach(&PrintToScreen,0.25); //Every second four times the values on screen
    
    while (true) 
    {
        if(PrintFlag) // if-statement for printing every second four times to screen
        {
            double KpPrint = 35*Potmeter2.read();
            pc.printf("Pos ref = %f, Pos motor = %f, Error = %f and Kp = %f\r",PosRefPrint,PosMotorPrint,ErrorPrint,KpPrint);
            PrintFlag = false;
        }
    }
}