#define APP_VERSION     0.6f
#define MQTT_VERSION    3
#define BROKER_NAME     "broker.hivemq.com"
#define BROKER_PORT     1883

#include "debounce_button.h"
#include "EthernetInterface.h"
#include "MQTTNetwork.h"
#include "MQTTmbed.h"
#include "MQTTClient.h"

char* topic = "embedded/controller";
bool connected = false;

DigitalOut led2(LED2); //led if connected
InterruptIn button(USER_BUTTON);
EthernetInterface eth;
MQTTNetwork network(&eth);
MQTT::Client<MQTTNetwork, Countdown> client(network);

/**
    TODO
    ----
    -   Check if the button has been pressed. If so, print the amount of clicks to a serial terminal.
    -   Make an MQTT-service which:
        -   starts up a network using EthernetInterface. Make sure the development board requests its address via DHCP.
        -   makes a client and connects it to the broker using a client ID and credentials (username & password).
        -   sends messages at the same topic as the smartphone app from PGO 2. Feel free to choose which Quality of Service
            you are going to use. Make a separate function which handles the sending procedure. Therefore, this function
            can be called each time we want to send a certain message.
    -   When the button is pressed once, we send an upvote. When pressed twice, a downvote is sent. By pressing 4 times,
        the program disconnects from the broker and terminates.
        
    Extra
    -----
    -   Subscribe to the topic on which the song data is published. Display this received message on the serial terminal.
    -   Test this controller in the complete system of PGO 2. Use these controllers instead of the smartphones.
    
    Tips & tricks
    -------------
    -   To generate an interrupt on the press of a button, use:
            InterruptIn button(USER_BUTTON);
            ...
            button.fall(callback(someFunction));
    -   Before implementing MQTT, test the multiclick feature first.
    -   Have a look at the MQTT-library for Mbed and the HelloMQTT-example.
    -   To have a uniform message sending procedure, use the following function usage:
            sendMessage(&client, topic, buf, qos, retained, duplicate)
*/

void MQQTConnect(){
    eth.connect();
    while(eth.get_ip_address()== NULL){
    }
    
    network.connect(BROKER_NAME, BROKER_PORT);
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = MQTT_VERSION;
    data.clientID.cstring = "client-ruben";
    data.username.cstring = "user";
    data.password.cstring = "pass";
    client.connect(data);

    connected = true;
    led2 = 1;
    printf("connected\n");
}

void sendMessage(MQTT::Client<MQTTNetwork, Countdown>& client, char* topic, char* buf, int qos, bool retained, bool duplicate){
    MQTT::Message message;
    
    switch(qos)
    {
        case 0:
            message.qos = MQTT::QOS0;
            break;
        case 1:
            message.qos = MQTT::QOS1;
            break;
        case 2:
            message.qos = MQTT::QOS2;
            break;
        default:
            message.qos = MQTT::QOS0;
    }
    
    message.retained = retained;
    message.dup = duplicate;
    message.payload = (void*)buf;
    message.payloadlen = strlen(buf) + 1;
    client.publish(topic, message);
}

int main(int argc, char* argv[])
{
    printf("\nBoot controller \nConnecting... \n");
    button.fall(callback(&button1_onpressed_cb));
    MQQTConnect();
    while(connected){
        if(!button1_busy && multiclick_state != 0){
            char* buf = "";
            switch(multiclick_state)
            {
                case 1:
                    buf = "upvote";
                    sendMessage(client, topic, buf, 0, false, false);
                    break;
                case 2:
                    buf = "downvote";
                    sendMessage(client, topic, buf, 0, false, false);
                    break;
                case 4:
                    client.disconnect();
                    network.disconnect();
                    connected = false;
                    led2 = 0;
                    break;
            }
            printf("click %d: %s \n", multiclick_state, buf);
            multiclick_state = 0;
        }
    }
    return 0;
}
