#include "mbed.h"
#include "C12832.h"
#include "MMA7660.h"

// Using Arduino pin notation
C12832 lcd(D11, D13, D12, D7, D10);
MMA7660 MMA(I2C_SDA,I2C_SCL);
enum Orientation {Up, Down,
                  Right, Left,
                  Back, Front,
                  Unknown
                 };

int main()
{
    lcd.cls();
    lcd.locate(0,3);
    // lcd.printf("mbed application shield!");

    while(1) {
        lcd.locate(60,0);
        lcd.printf("x=%.2f",MMA.x());
        lcd.locate(60,8);
        lcd.printf("y=%.2f",MMA.y());
        lcd.locate(60,16);
        lcd.printf("z=%.2f",MMA.z());
        lcd.locate(0,8);
        if (MMA.getSide()==Front) lcd.printf("Front");
        else if (MMA.getSide()==Back) lcd.printf("Back");
        lcd.locate(0,16);
        switch (MMA.getOrientation()) {
            case Left :
                lcd.printf("Left");
                break;
            case Right :
                lcd.printf("Right");
                break;
            case Up :
                lcd.printf("     ");lcd.locate(0,16);
                lcd.printf("Up");
                break;
            case Down :
                lcd.printf("Down");
                break;
        }

        wait(0.2);
    }
}
