#include "mbed.h"
#include "C12832.h"
DigitalIn up(A2);
DigitalIn down(A3);
DigitalIn left(A4);
DigitalIn right(A5);
DigitalIn center(D4);
C12832 lcd(D11, D13, D12, D7, D10);
enum {MATIN,MIDI,SOIR, PETIT, DEJ,DINER} menuPrincipal = MATIN;

int menu_precedent = MIDI;
char message_precedent[]="unMessageAuHasard";

void AttendreRelachementBoutons()
{
    if (up) while (up) wait(0.01);
    else if (down) while (down) wait(0.01);
    else if (left) while (left) wait(0.01);
    else if (right) while (right) wait(0.01);
    else if (center) while (center) wait(0.01);
}

void AttendreNouvelAppuiCenter()
{
    AttendreRelachementBoutons();
    while (!center) wait(0.01);
}

void Afficher_Message(char *Message)// Pour ne pas avoir de scintillement
{
    if (strcmp(message_precedent,Message) ==0) return;
    strcpy(message_precedent,Message);
    lcd.cls();
    lcd.locate(0,8);
    lcd.printf(Message);
    AttendreRelachementBoutons();
}

void Afficher_Menu(int Menu)
{
    switch(Menu) {
        case MATIN :
            Afficher_Message("Matin");
            break;
        case MIDI :
            Afficher_Message("Midi");
            break;
        case SOIR :
            Afficher_Message("Soir");
            break;
        case PETIT :
            Afficher_Message("Petit dejeuner");
            break;
        case DEJ :
            Afficher_Message("Dejeuner");
            break;
        case DINER :
            Afficher_Message("Diner");
            break;
    }
}

void Menu_Matin(int SousMenu)
{
    //main
    bool Sortir = false; // On sort du sous-menu
    while (!Sortir) {
        //while
        Afficher_Menu(SousMenu);

        switch (SousMenu) {
            //switch
            case PETIT :
                // évèments
                if (left) {
                    menuPrincipal = MATIN;
                    Sortir=true;
                }
                if (right) SousMenu=DEJ;
                if (center) {
                    Afficher_Message("Ok");
                    AttendreNouvelAppuiCenter();
                }
                break;
            case DEJ :
                // évèments
                if (left) SousMenu=PETIT;
                break;
            case DINER :
                break;

        }//switch


    }//while
}//main





int main()
{
    while (1) {
        Afficher_Menu(menuPrincipal);
        switch (menuPrincipal) {
            case MATIN :
                // évèments
                if (down) menuPrincipal = MIDI;
                if (right) Menu_Matin(PETIT);
                break;
            case MIDI :
                if (up) menuPrincipal = MATIN;
                break;
            case SOIR :
                break;
        }


    }

}
