/*

mbed Can-Bus demo

This program is to demonstrate the CAN-bus capability of the mbed module.

http://www.skpang.co.uk/catalog/product_info.php?products_id=741

v1.0 July 2010

********************************************************************************

WARNING: Use at your own risk, sadly this software comes with no guarantees.
This software is provided 'free' and in good faith, but the author does not
accept liability for any damage arising from its use.

********************************************************************************


*/

#include "mbed.h"
#include "ecu_reader.h"
#include "globals.h"


ecu_reader obdii(CANSPEED_500);     //Create object and set CAN speed

int main() {
    
    char buffer[20];
 
    pc.printf("\n\rCAN-bus demo...");

    while(1) {  // Main CAN loop
        led2 = 1;
        wait(0.1);
        led2 = 0;
        wait(0.1);
        
        if(obdii.request(ENGINE_RPM,buffer) == 1)   // Get engine rpm and display on LCD
        {
            pc.printf("%s\n\r", buffer);
        }   
         
        if(obdii.request(ENGINE_COOLANT_TEMP,buffer) == 1)
        {
            pc.printf("%s\n\r", buffer);
        }
        
        if(obdii.request(VEHICLE_SPEED,buffer) == 1)
        {
            pc.printf("%s\n\r", buffer);
        }
     
        if(obdii.request(THROTTLE,buffer) ==1 )
        {
            pc.printf("%s\n\r", buffer);
        }   
     
        if(obdii.request(MAF_SENSOR,buffer) ==1 )
        {
            pc.printf("%s\n\r", buffer);
        }   
     
        if(obdii.request(O2_VOLTAGE,buffer) ==1 )
        {
            pc.printf("%s\n\r", buffer);
        }          
    }
}