#ifndef OBDII_H
#define OBDII_H

#include "Eth.h"

#define CANSPEED_125      125000        // CAN speed at 125 kbps
#define CANSPEED_250      250000        // CAN speed at 250 kbps
#define CANSPEED_500      500000        // CAN speed at 500 kbps

 /* Details from http://en.wikipedia.org/wiki/OBD-II_PIDs */
#define ENGINE_COOLANT_TEMP 0x05
#define ENGINE_RPM          0x0C
#define VEHICLE_SPEED       0x0D
#define MAF_SENSOR          0x10
#define THROTTLE            0x11
#define O2_VOLTAGE          0x14
#define FUEL_LEVEL          0x2f

#define PID_REQUEST         0x7DF
#define PID_REPLY           0x7E8
#define PID_ENHANCED_REQUEST         0x7E0


class OBDII : public SocketReceiver
{

public:

    OBDII( CAN *c, DigitalOut *rs, int can_speed);
    
    void UpdateData(void);

private: 

    CAN *can;
    DigitalOut *canRS;
    
    void request(unsigned char pid);
    void EnhancedRequest(unsigned short pid);
    void readCAN();
    
    virtual void ReceivedData(int socketStatus, int len, char *msg);
    UDPSock *HostSock;
    Host *statusHost;

    // Use a timer to see if things take too long
    Timer CANTimer; 
    bool done;
    int mode;
    
    unsigned short currentRequest_;
    
    struct ecu_info {
        int coolantTemp;
        int rpm;
        int speed;
        int mafSensor;
        int throttle;
        int o2Voltage;
        int fuel;
        float mpg;
        
        unsigned int supported[256];
    } data;
};


#endif