#ifndef ETH_H
#define ETH_H

#include "EthernetNetIf.h"
#include "UDPSocket.h"

class Eth
{
public:
    Eth();
    ~Eth() {};
        
    void Operate(void);

private:

    EthernetNetIf *eth;
    Ticker checkNetTicker;
};

class SocketReceiver
{
public:
    virtual void ReceivedData(int status, int size, char *data) = 0;
};

class UDPSock
{
public:
    UDPSock(Host *l, int buff, SocketReceiver *sr);
    ~UDPSock() {};
    void SendTo(Host *remote, int size, char *data);
    
private:
    Host *local;
    Host *remote;
    UDPSocket udp;
    int bufferSize;
    char *buffer;
    SocketReceiver *receiver;

    void onUDPSocketEvent(UDPSocketEvent e);
 };

#endif