#include "Eth.h"

Eth::Eth()
{
    eth = new EthernetNetIf(IpAddr(10,10,10,2), IpAddr(255,255,255,0), IpAddr(10,10,10,1), IpAddr(10,10,10,1));
    EthernetErr ethErr = eth->setup();
    if(ethErr)
    {
        printf("Error %d in setup.\n", ethErr);
        return;
    }
    printf("Eth Setup OK\r\n");
    
//    checkNetTicker.attach(this, &Eth::Operate, 0.02f);
 }
 
void Eth::Operate(void)
{
    Net::poll();
}

UDPSock::UDPSock(Host *l, int buff, SocketReceiver *sr)
{
    local = l;
    bufferSize = buff;
    receiver = sr;
    buffer = new char[bufferSize];
    
    udp.setOnEvent(this, &UDPSock::onUDPSocketEvent);
    udp.bind(*local);
}

void UDPSock::SendTo(Host *remote, int size, char *data)
{
    udp.sendto(data, size, remote);
}

void UDPSock::onUDPSocketEvent(UDPSocketEvent e)
{
    switch(e)
    {
        case UDPSOCKET_READABLE: //The only event for now
            Host host;
            while( int len = udp.recvfrom( buffer, bufferSize, &host ) )
            {
                if( len <= 0 )
                    break;
                    
                receiver->ReceivedData(true, len, buffer);
            }
        break;
    }
}
