#ifndef RADIOEMULATOR_H
#define RADIOEMULATOR_H

#include "mbed.h"
#include "Eth.h"

#include "RadioState.h"


class RadioEmulator : public SocketReceiver
{
public:
    RadioEmulator(CAN *can, DigitalOut *rs, InterruptIn *irq, bool wdTO);
    ~RadioEmulator() {};
    
    void Operate(void);
    
    virtual void ReceivedData(int status, int size, char *data);
    
private:

    CAN *CANDevice;
    CANMessage can_MsgRx;
    DigitalOut *can_RS;
    InterruptIn *canIRQ;    
    UDPSock *HostSock;
    
    RadioState status;
    char siriusdata[512];
    int prevSWC;

//    void readInitFile();
//    void writeInitFile();

    void PowerUp(void);
    void PowerDown();
    
    enum {standalone, slave} opMode;

    void readCANbus(void);

    void SendOnMsg();
    void SendEVICMsg();
    void SendRadioModeMsg();
    void SendStereoSettingsMsg();
    void SendHostMessages();
    
    void ChangeSiriusStation(int station, bool turn_on);
    
    void StandaloneSWI();
    
    void ParseCANMessage(CANMessage can_MsgRx);
    void ReadSiriusText(char *data);    

    Ticker CANBusTicker;
    bool writeCANFlag;
    void WriteCANMessages();
    std::list<CANMessage> hostMessages;
    
    Ticker statusTicker;
    bool statusFlag;
    void SendStatusToHost();

    Ticker CANTimeout;
    bool CANTimeoutFlag;
    void CheckCANTimeout(void);
    void CANActivity(void);
    bool ReceivedCANMsg;
    bool needToParseCANMessage;
    int powerUpIRQCounter;
    bool sleeping;
    bool needToWakeUp;

    Ticker HostTimeout;
    bool hostTimeoutFlag;
    void CheckHostTimeout(void);
    bool ReceivedHostMsg;
    
    
    static char unlock[6];
    static char lock[6];
    static char trunk[6];
};

#endif