#include "WatchDogTimer.h"

void WatchDogTimer::kick(float s)
{
    LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
    uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4
    LPC_WDT->WDTC = s * (float)clk;
    LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
    kick();
}

// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
void WatchDogTimer::kick()
{
    LPC_WDT->WDFEED = 0xAA;
    LPC_WDT->WDFEED = 0x55;
}

// On reset, indicate a watchdog reset or a pushbutton reset  
bool WatchDogTimer::TimedOut()
{
    return ((LPC_WDT->WDMOD >> 2) & 1);
}

void WatchDogTimer::Disable()
{
    LPC_WDT->WDMOD = 0;
}