#ifndef RADIOEMULATOR_H
#define RADIOEMULATOR_H

#include "mbed.h"
#include "MODSERIAL.h"

#include "RadioState.h"

class RadioEmulator
{
public:
    RadioEmulator();
    ~RadioEmulator() {};
    
    void readCANbus(void);
    void HostComm(void);

//private:

    MODSERIAL *usb;
    void serialReceiver(void);
    
    void StartEmulation();
    void SendOnMsg();
    void SendEVICMsg();
    void SendRadioModeMsg();
    void SendStereoSettingsMsg();
    void ChangeSiriusStation(int station, bool turn_on);
    
    void readInitFile();
    void writeInitFile();
    void PowerUp(void);
    
    void WriteCANMessages();
    Ticker CANBusTicker;
    
    void SendStatusToHost();
    Ticker statusTicker;
    
    CAN *can2;
    CANMessage can_MsgRx;
    DigitalOut *can_RS;
    InterruptIn *canIRQ;
    void RestartCAN(void);
    
    int poweredDown;
      
    bool radioOn;
    
    void ParseCANMessage(CANMessage can_MsgRx);
    void ReadSiriusText(char *data);    
    char siriusText[8][8][8];
    
    
    char serialCounter;
    char msg[14];    

    static char unlock[6];
    static char lock[6];
    static char trunk[6];
    
    
    RadioState status;    
    
    Timeout buttonTimeout;
    void ClickTimeout(void);
    int prevSWC;
    int buttonClicks[6];
    bool buttonHeld[6];
    bool reportButtonClick;
    bool buttonClickTimedOut;

    bool ReceivedCANMsg;
    void CheckCANTimeout(void);
    Ticker CANTimeout;
    bool needToParseCANMessage;

    bool ReceivedHostMsg;
    void CheckHostTimeout(void);
    Ticker HostTimeout;
    
    enum {standalone, slave} opMode;
};

#endif