#ifndef RADIOSTATE_H
#define RADIOSTATE

enum radioMode { AM, FM, CD, SAT, VES, MAX_MODE };

struct RadioState
{
    radioMode _radioMode;
    
    int _amPreset;
    int _amFreq;
    
    int _fmPreset;
    int _fmFreq;
    
    int _cdNum;
    int _cdTrackNum;
    int _cdHours;
    int _cdMinutes;
    int _cdSeconds;
    char _cdTime[8];
    
    int _siriusPreset;
    int _siriusChan;
    char _siriusTextLine[8][64];
    
    int _evicMode;
    int _evicPreset;
    int _evicFreq;
    
    int _volume;
    int _balance;
    int _fade;
    int _bass;
    int _mid;
    int _treble;
    
    float _batteryVoltage;
    int _driverHeatedSeatLevel;
    int _passHeatedSeatLevel;
    char _vin[24];
    int _headlights;
    int _dimmerMode;
    int _dimmer;
    int _gear;
    int _brake;
    int _parkingBrake;
    char _vesControls[32];
    int _keyPosition;
    int _rpm;
    int _fanRequested;
    int _fanOn;
    int _rearDefrost;
    int _fuel;
    int _speed;
    
    int SWCButtons;
    int currentSWCAction;
};


#endif