#include "mbed.h"
#include "CAN.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

Serial pc(USBTX, USBRX); // tx, rx   default settings (9600 8N1)


CAN can1(p9, p10);      // CAN1 uses pins 9 and 10 (tx, rx)
CAN can2(p30, p29);     // CAN2 uses pins 30 and 29 (tx, rx)

DigitalOut can1_SleepMode(p11);     // Use pin 11 to control the sleep mode of can1
DigitalOut can2_SleepMode(p28);     // Use pin 28 to control the sleep mode of can2

CANMessage can_MsgTx;
CANMessage can_MsgRx;

char msg[14];
char counter = 0;

int main()
{
    pc.baud(115200);        // change serial interface to pc to 115200, 8N1

    can1.frequency(500000);     // many frequencies are supported
    
    can2.frequency(83000);      // last time I checked 83000 was not, so....
    LPC_CAN2->BTR = 0x52001C;   // I had to manually change the "registers" that control the frequency
                                // the registers are coded weird, so mbed tried to hide that
                                // so usually you only need to issue the can2.frequency() command
    
    can1_SleepMode = 0;         // Set the Sleep Mode to 0 or low or false... this makes sure the transceiver is on
    can2_SleepMode = 0;         // Set the Sleep Mode to 0 or low or false... this makes sure the transceiver is on
    
    while (1)
    {
        // send received messages to the pc via serial line
        if (can2.read(can_MsgRx))
        {
            // When sending a message to the PC, send a couple of sync bytes so that when the PC looks, it finds the start of a message
            // putc will write a character/byte to the pc, getc reads a character/byte from the pc
            pc.putc(0xff);
            pc.putc(0x00);
            pc.putc(0xff);

            // Now, start sending the data of the message
            
            // The id is 2 bytes long, so I have to break it up
            pc.putc((can_MsgRx.id & 0xff00) >> 8);      // select the first byte... and write it
            pc.putc((can_MsgRx.id & 0x00ff));           // select the second byte... and write it
            pc.putc(can_MsgRx.len);                     // send the length of the can message
            for (int i = 0; i < can_MsgRx.len; i++)
            {
                pc.putc(can_MsgRx.data[i]);             // send each of the bytes... from the first byte to the last byte.
            }
            
            // any incoming message: toggle led2
            led2 = !led2;
        }
        
        // send received messages to the pc via serial line
        if (can1.read(can_MsgRx))
        {
            // When sending a message to the PC, send a couple of sync bytes so that when the PC looks, it finds the start of a message
            // putc will write a character/byte to the pc, getc reads a character/byte from the pc
            pc.putc(0xff);
            pc.putc(0x00);
            pc.putc(0xff);

            // Now, start sending the data of the message
            
            // The id is 2 bytes long, so I have to break it up
            pc.putc((can_MsgRx.id & 0xff00) >> 8);      // select the first byte... and write it
            pc.putc((can_MsgRx.id & 0x00ff));           // select the second byte... and write it
            pc.putc(can_MsgRx.len);                     // send the length of the can message
            for (int i = 0; i < can_MsgRx.len; i++)
            {
                pc.putc(can_MsgRx.data[i]);             // send each of the bytes... from the first byte to the last byte.
            }
            
            // any incoming message: toggle led3
            led3 = !led3;
        }

        // repeat this section of code if there is any bytes coming from the PC
        while (pc.readable())
        {
            msg[counter] = pc.getc();       // read the byte from the pc, and put it into a buffer at the next available position
            counter++;                      // update the next available position
            
            if (counter == 14)              // if we received a full message (14 bytes) from the PC, then break out of the loop
            {
                break;
            }
            
            if (counter == 3)       // if we have received the first 3 bytes, check to see if they are the sync
            {
                if ((msg[0] != 0xff) || (msg[1] != 0x00) || (msg[2] != 0xff))
                {
                    counter = 2;            // if they aren't the sync, skip the first byte by...
                    msg[0] = msg[1];        // moving the second and third bytes into the first and second spots
                    msg[1] = msg[2];
                }
            }
            
            // Only stop repeating if all 14 bytes have been received from the pc, or if the pc isn't sending any more bytes
        }
        
        // So... if the pc sent a full message
        if (counter > 13)
        {
            counter = 0;        // reset the buffer
            
            // doublecheck to see if the sync was in the pc message
            if ((msg[0] == 0xff) && (msg[1] == 0x00) && (msg[2] == 0xff))
            {
                // Start filling in the data into the can tx message...
                can_MsgTx.id = (((short)msg[3]) << 8) + msg[4];     // make the id from the 2 bytes
                can_MsgTx.len = msg[5];                             // set the size of the message
                for (int i = 0; i < 8; i++)                         // fill in all 8 bytes
                {
                    can_MsgTx.data[i] = msg[6 + i];                 // make sure to use the right bytes offset from the start
                }
                
                led1 = !led1;           // toggle the led to show that we sending a can message on the second CAN transceiver
                can2.write(can_MsgTx);  //send the message

                memset(msg, 0, 14);    // clear out the pc interface's buffer
            }
        }
    }
}