/*******************************************************************************
* Copyright (C) Maxim Integrated Products, Inc., All rights Reserved.
*
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

#ifndef IMG_UTILS_H_INCLUDED
#define IMG_UTILS_H_INCLUDED

#include <stdint.h>

int getMaxPixelValue(const int pixels[], const unsigned int num_pixels);
int getMinPixelValue(const int pixels[], const unsigned int num_pixels);
unsigned int zeroPixelsBelowThreshold(int pixels[], const unsigned int num_pixels, const int threshold);
void filterLowPassPixels(int pixels[], float filtpixels[], const unsigned int num_pixels, const float alpha);
void subtractBackground(int pixels[], float short_avg_pixels[], float long_avg_pixels[], const unsigned int num_pixels, const float alpha_short_avg, const float alpha_long_avg);
void calcCenterOfMass(const int pixels[], const unsigned int xres, const unsigned int yres, float *cmx, float *cmy, int *totalmass);
void interpn(const int pixels[], int interp_pixels[], const int w, const int h, const int interpolation_factor);

#endif
