/**
    Temperature Sensor and Logging for hw8
    main.cpp
*/

// INCLUDES
#include "mbed.h"
#include "sensors.h"
#include "dataLog.h"

DigitalOut ledData(LED1);
DigitalOut ledAccel(LED2);

void initiateLogs(void);
void runDataLog(void);
void startAccelLog(void);
void endAccelLog(void);
void runAccelLog(void);

SDFileSystem sd( PIN_SD_MOSI, PIN_SD_MISO, PIN_SD_SCLK, PIN_SD_CS, "sd" );
char dataLog [20] = "/sd/tempLog.csv";
char accelLog [20] = "/sd/accelLog.csv";
FILE *fpData;
FILE *fpAccel;

Timer accelLogTimer;
float currentTime;
float currentVoltage;
float currentTemp;
float startingTemp;


// OUTPUTS
Serial pc(USBTX, USBRX);        // for debugging



// VARIABLES
Timer t;


// Variables for sensors
Ticker dataLogger;

MMA8452Q accel( PIN_ACCEL_SDA, PIN_ACCEL_SCL, 0x1D );
InterruptIn accelInterrupt(PIN_ACCEL_INTERRUPT);
Ticker accelLogger;

int main()
{
    initiateLogs();

    // Set up accelerometer
    accel.init();
    accelInterrupt.fall(&startAccelLog);

    //start timer and begin main loop
    t.start();
    while(1) {
        ledData = 0;
        while( !readSwitch() ) {

            // nothing happens when the switch is off
        }
        // Once switch is on intiate all logs
        // and start loop until switch is off
        fpData = fopen( dataLog, "a" );
        dataLogger.attach( &runDataLog, .5 );
        ledData = 1;
        while(readSwitch()) { // Main loop for logging

            wait( .1 );

        } // exit loop when switch is turned off
        dataLogger.detach();
        fclose( fpData );

    } // restart main loop and wait for switch
}


void runDataLog()
{
    // get all data for current time
    currentTime = t.read();
    currentVoltage = readTempSensor();
    currentTemp = mvToTemp( currentVoltage );

    // Record to file
    fprintf( fpData, "%f, %f, %f, %f \n", currentTime, currentVoltage, currentTemp, currentTemp-startingTemp );


}

void initiateLogs()
{
    // Take initial reading for comparison
    startingTemp = mvToTemp( readTempSensor() );

    // Mount the sd
    sd.mount();

    // Open new files and create headers
    fpData = fopen( dataLog, "r" );
    if ( fpData==NULL ) {
        fpData = fopen( dataLog, "w" );
        fprintf(fpData,"Time (s), Voltage (mv), Temperature (C), Delta T (C)\n\r");
    }
    fclose( fpData );

    fpAccel = fopen( accelLog, "r" );
    if ( fpAccel==NULL ) {
        fpAccel = fopen( accelLog, "w" );
        fprintf(fpAccel, "Time (s), X, Y, Z \n");
    }
    fclose( fpAccel );
}

void startAccelLog()
{
    fpAccel = fopen( accelLog, "a" );
    accelLogTimer.reset();
    accelLogTimer.start();
    accelLogger.attach( &runAccelLog, 0.02 );
    ledAccel = 1;
}



void runAccelLog()
{
    if ( accelLogTimer<3 ) {
        float x = accel.readX();
        float y = accel.readY();
        float z = accel.readZ();

        fprintf( fpAccel, "%f, %f, %f, %f \n\r", t.read(), x, y, z );
    } else {
        endAccelLog();
        return;
    }
}

void endAccelLog()
{
    ledAccel = 0;
    accelLogTimer.stop();
    accelLogger.detach();
    fclose( fpAccel );
    accel.readRegister( REG_TRANSIENT_SRC );
}