/**
    Temperature Sensor and Switch Read
    OCE360Input.cpp

    Purpose: Read a switch connected at p7
             Read a temperature sensor connected at p20
        
    @author  Russell Shomberg
    @created 2018-10-25
    @revised 2018-10-25
    @version 0.0
    
    Issues:    
    
*/ 
// INCLUDES
#include "mbed.h"
#include "OCE360Input.h"

// DEFINES
#define VREF 3.3
#define TEMP_CALIBRATION_A 0.1
#define TEMP_CALIBRATION_B -50

DigitalIn myswitch(p9);
AnalogIn Ain(p20);

int switchPosition;
int sensorVoltage;
int sensorTemp; 

int read_switch(void) {
    return myswitch;    
}

float read_sensor(void){
    return Ain*VREF*1000;  // voltage in mV
}

float convert_mV_to_temp(float sensorVoltage) {
    return sensorVoltage*TEMP_CALIBRATION_A+TEMP_CALIBRATION_B; //temp in deg C
}
