/**
    Temperature Sensor and Logging for hw7
    main.cpp

    Purpose:    Read signal from TMP36 connected to pin20
                Toggle switch connected to pin07 activates SD logging
                Log: Time Elasped, Current Voltage, Current Temp, Delta Temp
                Finish log -> save file and send to USB serial port

    @author  Russell Shomberg
    @created 2018-10-31
    @revised 2018-10-31
    @version 0.0

    Issues: SD Card Writing functions need to be in a seperate file

*/

// INCLUDES
#include "mbed.h"
#include "OCE360Input.h"
#include "SDFileSystem.h"

// OUTPUTS
Serial pc(USBTX, USBRX);        // for debugging

// VARIABLES
int outputT= 0;
float starting_voltage;
float starting_temp;

float current_time;
float current_voltage;
float current_temp;
int file_counter=0;
char file_name [20];
Timer t;
FILE *fp;
unsigned char c;                          // a single byte buffer

// Initialize SDFileSystem
SDFileSystem sd(p5,p6,p7,p8,"sd");



int main()
{
    //Initialize Timer
    t.start();

    // Mount the sd and
    printf("\n\r\n\rMounting SD Card\n\r");
    sd.mount();

    while(1) {
        while(!read_switch()) {}

        while(read_switch()) {  // skip everything if switch is off

            // Initialize a file
            printf("Opening a new file: temp_log%d.csv\n\r",file_counter);
            sprintf(file_name,"/sd/temp_log%d.csv",file_counter);
            fp = fopen(file_name,"w");

            if (fp!=NULL) { // Don't procede if there is an issue

                // Write header to file
                fprintf(fp,"Time (s), Voltage (mv), Temperature (C), Delta T (C)\n\r");

                // Take initial readings
                starting_voltage = read_sensor();
                starting_temp = convert_mV_to_temp(starting_voltage);

                // start a loop that logging
                // exiting this loop will initialize data save procedures
                printf("Logging data....\n\r");
                while(read_switch()) { // Main loop for logging

                    // Get data for logging
                    current_time = t.read();
                    current_voltage = read_sensor();
                    current_temp = convert_mV_to_temp(current_voltage);

                    fprintf(fp,"%1.2f, %1.2f, %1.2f, %1.2f \n\r", current_time, current_voltage, current_temp, current_temp-starting_temp);

                    wait(1);
                }

                // This code runs when the switch is toggled off
                // Close out file
                printf("Logging complete! \n\r Saving file \n\r");
                fclose(fp);

                // Print to USB serial
                printf("Uploading data to USB \n\r");
                //
                fp = fopen(file_name,"r");
                if (fp!=NULL) { // Don't procede if there is an issue
                    while (!feof(fp)) {                       // while not end of file
                        c=fgetc(fp);                         // get a character/byte from the file
                        printf("%c",c); // and show it in hex format
                    }
                } else { // runs if there was a issue opening the file
                    printf("Issue with opening file\n\r");
                    fclose(fp);
                }


            } else { // runs if there was a issue opening the file
                printf("Issue with opening file\n\r");
            }
        }

        // Re-enter main while loop
        //continuously check for switch to turn on again
        file_counter++;
        printf("waiting...");
    }
}