/**
    Temperature Sensor for hw6
    SegDisplay.cpp

    Purpose: Convert an integer value to a hex
             Hex output represents binary required to make a 7-seg led show the integer value
             Pin configuration for 7-Seg
             ones: 12 13 14 15 16 17 18 19
                    A  B  C  D  E  F  G  P 
             tens: 21 22 23 24 25 26 27 28
        
    @author  Russell Shomberg
    @created 2018-10-23
    @revised 2018-10-30
    @version 0.0
    
    Issues: No Decimal point for temperature    
    
*/ 

// INCLUDES
#include "mbed.h"
#include "SegDisplay.h"

// INPUTS
BusOut Seg1(p12,p13,p14,p15,p16,p17,p18,p19); //01 02 03 04 05 06 07 08 09 10
BusOut Seg2(p21,p22,p23,p24,p25,p26,p27,p28); //E  D  CC C  DP B  A  CC F  G

int ones; // ones digit of output
int tens; // tens digit of output

char SegConvert(int SegValue) {         // function 'SegConvert'
    // Converts a integer value to a hexidecimal output
    // the output corresponds to a bus connected to the segdisplay
    // bus recreates the original integer
    char SegByte=0x00;
    switch (abs(SegValue)) {           // ABCDEFGP
        case 0 : SegByte= 0x3F;break;  // 11111100 binary
        case 1 : SegByte= 0x06;break;  // 01100000 binary
        case 2 : SegByte= 0x5B;break;  // 11110110 binary
        case 3 : SegByte= 0x4F;break;  // 10011110 binary
        case 4 : SegByte= 0x66;break;  // 11001100 binary
        case 5 : SegByte= 0x6D;break;  // 11011010 binary
        case 6 : SegByte= 0x7D;break;  // 11111010 binary
        case 7 : SegByte= 0x07;break;  // 00001110 binary
        case 8 : SegByte= 0x7F;break;  // 11111110 binary
        case 9 : SegByte= 0x6F;break;  // 11011110 binary
    }
    return ~SegByte;
}

void SegWrite(float val){
        // Convert val to ones and tens char
        ones = fmod(rint(val),10);
        tens = fmod(rint(val) / 10, 10); 
        
        Seg1 = SegConvert(ones);
        Seg2 = SegConvert(tens);
}