/**
    Temperature Sensor for hw6
    main.cpp

    Purpose:    Read signal from TMP36 connected to pin20
                Display output voltage to terminal
                Display difference in mV of output voltage to starting voltage on 2x 7-Segment Displays
                    See outputs for pin configuration
                Toggle switch connected to pin07 to convert displays to degC
    
    @author  Russell Shomberg
    @created 2018-10-23
    @revised 2018-10-25
    @version 0.0
    
    Issues: No Decimal point for temperature    
    
*/ 

// INCLUDES
#include "mbed.h"
#include "SegDisplay.h"
#include "OCE360Input.h"

// OUTPUTS
Serial pc(USBTX, USBRX);        // for debugging

// VARIABLES
int outputT= 0;
float v0;
float deltav;
float val;


int main() {
    // read starting voltage from temperature sensor
    v0 = read_sensor();
    
    while(1) {
        // Read Switch if on output temp else output mV
        outputT = read_switch();
        deltav = read_sensor()-v0;
        
        // Output to terminal
        if (outputT) {
            // Convert to temp
            val = convert_mV_to_temp(deltav);
            //printf("Temperature Difference = %1.2f degC\n\r", val);
        }

        else {
            val = deltav;
            //printf("Voltage Difference = %1.2f mV\n\r", val);
        }
        
        SegWrite(val);
                
        wait(1);
        
    }
    
}

