/**
    Temperature Sensor
    main.cpp

    Purpose:    Read signal from TMP36 connected to pin20
                Display output voltage to terminal
                Display difference in mV of output voltage to starting voltage on 2x 7-Segment Displays
                    See outputs for pin configuration
                Toggle switch connected to pin07 to convert displays to degC
    
    @author Russell Shomberg
    @version 1.0 2018-10-15
    
    Issues: No Decimal point for temperature    
    
*/ 

// INCLUDES
#include "mbed.h"

// INPUTS
DigitalIn switchPosition(p7);   // wire p7 to middle connection of 2 position switch between Vref and GND
AnalogIn Ain(p20);              // wire p20 to a variable resister connected from Vref and GND

// OUTPUTS
Serial pc(USBTX, USBRX);        // for debugging

//// Pin Map for 7-Seg starts bottom left, goes CCW
BusOut Seg1(p12,p13,p14,p15,p16,p17,p18,p19); //01 02 03 04 05 06 07 08 09 10
BusOut Seg2(p21,p22,p23,p24,p25,p26,p27,p28); //E  D  CC C  DP B  A  CC F  G

// FUNCTIONS
char SegConvert(int SegValue);

// VARIABLES
int outputT= 0;
float v0;
float deltav;
float temp0;
float deltatemp;
float val;
int ones;
int tens;


int main() {
    // read starting voltage from temperature sensor
    v0 = Ain*3.5*1000;
    
    while(1) {
        // Read Switch if on output temp else output mV
        outputT = switchPosition;
        
        // Read temperature sensor
        deltav = Ain*3.5*1000-v0;
        
        // Output to terminal
        if (outputT) {
            // Convert to temp
            deltatemp = deltav/10;
            printf("Temperature Difference = %1.2f degC\n\r", deltatemp);
            val = deltatemp;
        }

        else {
            printf("Voltage Difference = %1.2f mV\n\r", deltav);
            val = deltav;
        }
        
        // Convert val to ones and tens char
        ones = fmod(rint(val),10);
        tens = fmod(rint(val) / 10, 10);
        

        Seg1 = ~SegConvert(ones);
        Seg2 = ~SegConvert(tens);
        
        
        wait(1);
        
    }
    
}


//ones: 12 13 14 15 16 17 18 19
//      A  B  C  D  E  F  G  P 
//tens: 21 22 23 24 25 26 27 28
//

char SegConvert(int SegValue) {         // function 'SegConvert'
    char SegByte=0x00;
    switch (abs(SegValue)) {           // ABCDEFGP
        case 0 : SegByte= 0x3F;break;  // 11111100 binary
        case 1 : SegByte= 0x06;break;  // 01100000 binary
        case 2 : SegByte= 0x5B;break;  // 11110110 binary
        case 3 : SegByte= 0x4F;break;  // 10011110 binary
        case 4 : SegByte= 0x66;break;  // 11001100 binary
        case 5 : SegByte= 0x6D;break;  // 11011010 binary
        case 6 : SegByte= 0x7D;break;  // 11111010 binary
        case 7 : SegByte= 0x07;break;  // 00001110 binary
        case 8 : SegByte= 0x7F;break;  // 11111110 binary
        case 9 : SegByte= 0x6F;break;  // 11011110 binary
    }
    return SegByte;
}