/**
    MBED Analug Output Triangle Wave and PWM Wave
    main.cpp

    Purpose:    Output a triangle waveform
                Output a PWM Signal of same frequency
                Adjust LED1 brightness with PWM Signal
                Adjust frequency using variable resistor
                Adjust amplitude using switch

    @author Russell Shomberg
    @version 1.0 2018-10-04
    
    Issues: 
        Frequency and amplitude only change at the start of the waveform by design
            

*/

// INCLUDES
#include "mbed.h"

// INPUTS
DigitalIn switchPosition(p7);   // wire p7 to middle connection of 2 position switch between Vref and GND
AnalogIn Ain(p20);              // wire p20 to a variable resister connected from Vref and GND

// OUTPUTS
Serial pc(USBTX, USBRX);        // for debugging
AnalogOut Aout(p18);            // leave open lead on p18 for signal output
PwmOut myled(LED1);
PwmOut mypwm(p21);

// VARIABLES
float period;       // range between ~0 and 1 (seconds)
float pwmfreq;    // switch between 1 and -.5
float i;            // index

int main() {
         
    while(1) {
        // Check settings at start of loop which are changed with 
        period = Ain;
        if (switchPosition==1) {pwmfreq = 1*period;}
        else {pwmfreq = .5*period;}
        
        // Debugging code
        //printf("PWM Frequency = %1.2f Hz\n\r", pwmfreq);
        //printf("Analog Period = %1.2f seconds\n\r", period);
        
        //mypwm.period(period);
        //mypwm = pwmfreq;
        
        for (i=0;i<1;i=i+.001){
                myled = 1-i;
                mypwm = 1-i;
                Aout = i;
                wait(0.001*period);
            }
            
        for (i=1;i>0;i=i-.001){
                Aout = i;
                myled = 1-i;
                mypwm = 1-i;
                wait(0.001*period);
            }
    }
}
