/**
    MBED Analug Output Triangle Wave
    main.cpp

    Purpose:    Output a triangle waveform
                Adjust frequency using variable resistor
                Adjust amplitude using switch

    @author Russell Shomberg
    @version 1.0 2018-09-25
    
    Issues: 
        Frequency and amplitude only change at the start of the waveform by design
            

*/

// INCLUDES
#include "mbed.h"

// INPUTS
DigitalIn switchPosition(p7);   // wire p7 to middle connection of 2 position switch between Vref and GND
AnalogIn Ain(p20);              // wire p20 to a variable resister connected from Vref and GND

// OUTPUTS
Serial pc(USBTX, USBRX);        // for debugging
AnalogOut Aout(p18);            // leave open lead on p18 for signal output

// VARIABLES
float period;       // range between ~0 and 1 (seconds)
float amplitude;    // switch between 1 and -.5
float i;            // index

int main() {
    while(1) {
        
        // Check settings at start of loop which are changed with 
        if (switchPosition==1) {amplitude = 1;}
        else {amplitude = 0.5;}
        
        period = Ain;
        
        // Debugging code
        //printf("Amplitude = %1.2f Volts\n\r", amplitude * 3.3f);
        //printf("Period = %1.2f seconds\n\r", period);
        
        for (i=0;i<1;i=i+.001){
                Aout = i*amplitude;
                wait(0.001*period);
            }
            
        for (i=1;i>0;i=i-.001){
                Aout = i*amplitude;
                wait(0.001*period);
            }
    }
}
