#ifndef __IROBOT__
#define __IROBOT__

#include "mbed.h"

class iRobot
{

public:

    iRobot(PinName tx, PinName rx);
    void start();
    void forward();
    void reverse();
    void left();
    void right();
    void stop();
    void playsong();
    void charger();
    void changeSpeed(int speed);
    void receive_sensor();
    char sensorCode();
    int getAngle();
    void turnAngle(int angle);

private:

    //                 Create Command              // Arguments
    static const char         Start = 128;
    static const char         SafeMode = 131;
    static const char         FullMode = 132;
    static const char         Drive = 137;                // 4:   [Vel. Hi] [Vel Low] [Rad. Hi] [Rad. Low]
    static const char         DriveDirect = 145;          // 4:   [Right Hi] [Right Low] [Left Hi] [Left Low]
    static  const char         Demo = 136;                 // 2:    Run Demo x
    static  const char         Sensors = 142;              // 1:    Sensor Packet ID
    static  const char         CoverandDock = 143;         // 1:    Return to Charger
    static  const char         SensorStream = 148;         // x+1: [# of packets requested] IDs of requested packets to stream
    static  const char         QueryList = 149;            // x+1: [# of packets requested] IDs of requested packets to stream
    static  const char         StreamPause = 150;          // 1:    0 = stop stream, 1 = start stream
    static  const char         PlaySong = 141;
    static const char         Song = 140;
    static  const char         BumpsandDrops = 7;
    static const char         Distance = 19;
    static const char         Angle = 20;
    static const char         waitAngle = 157;
    /* Global variables with sensor packet info */
    char Sensor_byte_count;
    char Sensor_Data_Byte;
    char Sensor_Data_Byte_Error;
    char Sensor_ID;
    char Sensor_Num_Bytes;
    char Sensor_Checksum;

    int speed_left;
    int speed_right;
    Serial device;
};

#endif