// Bouncing ball is a library adding physics based ball bouncing to the Sparkfun Experiment 3/4 rolling ball demo.
// Example Code
// 10/19/2017 Stephen Licht 

#include "mbed.h"

#ifndef bouncing_ball_H
#define bouncing_ball_H  //in case any other library wishes to check for presence of this library (see example below)
#include "MMA8452Q.h"  //includes our new accelerometer library definitions

#define DEFAULT_WIDTH 128
#define DEFAULT_HEIGHT 128
#define DEFAULT_SPEEDX 0
#define DEFAULT_SPEEDY 0
#define DEFAULT_POSX 64
#define DEFAULT_POSY 64
#define DEFAULT_COLOR 0
#define DEFAULT_RADIUS 10
#define GRAVITY 9.81
#define BUFFER 1

// Class declaration
class physics_ball
{
    public:
        physics_ball();
        ~physics_ball();

        float speedx;
        float speedy;
        int posx;
        int posy;
        int color;
        int radius; 
        
        void update(float time_step, MMA8452Q &accelerometer);
        void define_space(int desired_width, int desired_height);
        void set_param(int desired_radius, int desired_color);
        void set_state(int desired_x, int desired_y, float desired_vx, float desired_vy);
        
    private:

        int _width;
        int _height;
        int _upside_down_status;
        float _posx_f;
        float _posy_f;
        
        void _reset_upside_down();
};

#endif  //bouncing_ball_H


