/*
R. Sean Nagle
0CE306 HW6
*/

#include "mbed.h"
#include "MMA8452Q.h"           //acceleromater library
#include "uLCD_4DGL.h"          //LCD library
#include "bouncing_ball.h"      //new ball phyics library
#include "SDFileSystem.h"

#define UPDATE_TIME_S 0.02
#define START_X_1 10
#define START_Y_1 10
#define START_X_2 20
#define START_Y_2 20
#define RADIUS_1 6
#define RADIUS_2 3

#define DEBUG_MODE 0

#define LCD_UPDATE .091         //11 Hz

// Accelerometer - SDA, SCL, and I2C address
MMA8452Q accel(p28, p27, 0x1D);  //initialize a driver object for an accelerometer connected on pins 27-28.

// Analog input (pin 15)
AnalogIn tempin(p15);

//Initialize Serial communication
Serial pc(USBTX, USBRX);

// SD card (SPI pins)
SDFileSystem sd(p5, p6, p7, p8, "sd");

//Drawing positions
int lastx1;
int lasty1;
int lastx2; 
int lasty2;

//Led Initialization
DigitalOut led1(LED1); //update leds
DigitalOut led2(LED2);
DigitalOut led3(LED3);

//Function prototype for color selection function:
int get_LCD_color(int color_integer);

// Graphic LCD - TX, RX, and RES pins
uLCD_4DGL uLCD(p9,p10,p11);     //initialize a driver object for an LCD connected on pins 9-11

physics_ball ball1;  //initialize two balls for bouncing
physics_ball ball2;  //the default states from the library will be used initially

//Ticker for update
Ticker update1; //ball 1 ticker for update position
Ticker update2; //ball 2 ticker for update position

//Toggle Initialization
InterruptIn button(p18);    //Interrupt on the button on pin 13
Timer debounce;             //defines debounce timer for proper switching
Timer logtimer;
int updtog = 0;

void toggle(){
    if(debounce.read_ms()>175){
        led3= !led3;
        debounce.reset(); //restart timer after toggle occurs
        logtimer.start();
        if(logtimer.read()<2){
            updtog = 1;
            }
        }
    }
/*    
int v1x;
int v1y;
int v2x;
int v2y;
*/

void ball1up(){
    if (updtog == 0){
        ball1.update(UPDATE_TIME_S,accel);  //updates position
        /*
        v1x = (int)ball1.speedx;
        v1y = (int)ball1.speedy;
        */
        }
    else {
        ball1.set_state(ball1.posx,ball1.posy,0,0); //speeds are set to zero
        //pc.printf("%i    %i\r\n",v1x,v1y);
        if(logtimer.read()>2){
            //ball1.set_state(ball1.posx,ball1.posy,v1x,v1y);
            logtimer.stop();
            logtimer.reset();
            updtog = 0;
            }
        }
    led1 = !led1;                       //changes led state every update
    }

void ball2up(){
    if (updtog == 0){
        ball2.update(UPDATE_TIME_S,accel);  //updates position
        /*
        v2x = (int)ball2.speedx;
        v2y = (int)ball2.speedy;
        */
        }
    else {
        ball2.set_state(ball2.posx,ball2.posy,0,0); //speeds are set to zero
        //pc.printf("%i    %i\r\n",v2x,v2y);
        if(logtimer.read()>2){
            //ball2.set_state(ball2.posx,ball2.posy,v2x,v2y);
            logtimer.stop();
            logtimer.reset();
            updtog = 0;
            }
        }
    led2 = !led2;                       //changes led state every update
    }

//Freefall Interrupt
InterruptIn FREEFALL(p17);
DigitalIn tompetty(p17);

//Ticker for display
Ticker displayup;   //ticker for displaying ball on lcd

void display(){
    
    // Erase old circles by writing over there locations using the screen color:
    uLCD.filled_circle(lastx1, lasty1, ball1.radius, BLACK);
    uLCD.filled_circle(lastx2, lasty2, ball2.radius, BLACK);
    
    // Draw circles in the x and y positions stored by the ball objects:
    uLCD.filled_circle(ball1.posx, ball1.posy, ball1.radius, get_LCD_color(ball1.color));
    uLCD.filled_circle(ball2.posx, ball2.posy, ball2.radius, get_LCD_color(ball2.color));
    
    //Sets previous ball position to be erased in next iteration
    lastx1 = ball1.posx;
    lasty1 = ball1.posy;
    lastx2 = ball2.posx;
    lasty2 = ball2.posy;
    }

int main(){
    
    // Initialize uLCD
    uLCD.baudrate(115200);
    uLCD.background_color(BLACK);
    uLCD.cls();
    
    // Initialize accelerometer
    accel.init();
    // Initialize freefall
    accel.freefall(0x04,0x03); //0x04 for pin 1, 0x00 for pin 2, threshold = (threshold)/0.063 = counts to set register to
                                                            //   example, thresh <0.2g, 

    //Initialize balls:
    ball1.set_state(START_X_1,START_Y_1,0,0); //speeds are set to zero
    ball1.set_state(START_X_2,START_Y_2,0,0);

    //Set ball radius and color:
    ball1.set_param(RADIUS_1,0); //color is unimportant
    ball2.set_param(RADIUS_2,1); //just making sure the colors are different

    update1.attach(&ball1up,UPDATE_TIME_S); //ticker force position update ball 1
    update2.attach(&ball2up,UPDATE_TIME_S); //ticker force position update ball 2
    
    displayup.attach(&display,LCD_UPDATE);   //ticker force lcd update
    
    debounce.start();       //starts debounce timer
    button.rise(&toggle);   //toggles on button press
    //FREEFALL.rise(&toggle); //interrupts on free fall
    FREEFALL.fall(&toggle); //interrupts on free fall  
        
    while (1) {  //execute 'forever'
    
        uint8_t sixteen = accel.readRegister(0x16);
        sixteen &= 0x80;
        //pc.printf("%u\n\r",sixteen);
        
        
        if (tompetty == 0){
            pc.printf("LOW       %u\n\r",sixteen);
            }
        else {
            pc.printf("HIGH      %u\n\r",sixteen);
            }
        
        
        if (DEBUG_MODE) {
            //If compiled with DEBUG_MODE flag raised, print values to screen.
            uLCD.locate(0,4);
            uLCD.printf("X: %d.1\nY: %.1d",ball1.posx,ball1.posy);
    
            uLCD.locate(0,6);
            uLCD.printf("VX: %f.1\nVY: %.1f",ball1.speedx,ball1.speedy);
    
            uLCD.locate(0,10);
            uLCD.printf("AX: %f.1\nAY: %.1f\nAZ: %0.1f",accel.readX(),accel.readY(),accel.readZ());
        }
    }
}

//Interpret LCD colors.
int get_LCD_color(int color_integer)
{
    switch (color_integer) {
        case 0:
            return(RED);
        case 1:
            return(BLUE);
        case 2:
            return(GREEN);
        default:
            return(WHITE);
    }
}            