#include "mbed.h"
#include "ledScreen.h"

// screen instance
ledScreen screen;

// sin lookup table and related functions
unsigned char sinlut[256];

void initSinLut() {
    for (int i=0; i<256; i++)
        sinlut[i] = cos((float)i / 256.0 * (3.14159265 * 2))*127 + 128;
}

inline unsigned char lut_sin(int x) {

    return (x>0)?sinlut[x%256]:sinlut[(-x)%256];
}


// Example frame makes:


//rainbow
void makeFrame1(unsigned char* data) {

    static int time=0;
    time++;
    
    // override data with a intensity gradient test pattern
    for (int x=0; x<3*16; x++) {
        for (int y=0; y<48; y++) {

            int i = (x + y*(16*3)) * 3;  // figure out the memory location

            data[i] = lut_sin((x+y)*255/48+(time/2)%256); //(sin((float)(x+time)/15.0)+1.0)*128 ;   // red
            data[i+1] = lut_sin(((x+y)*255/48+(time/2)+ 85)%256); //(sin((float)(x+time)/15.0)+1.0)*128 ;   // red
            data[i+2] = lut_sin(((x+y)*255/48+(time/2)+170)%256); //(sin((float)(x+time)/15.0)+1.0)*128 ;   // red
        }
    }

}

//cool lines
void makeFrame2(unsigned char* data) {

    static int time=0;
    time++;
    
    // override data with a intensity gradient test pattern
    for (int x=0; x<3*16; x++) {
        for (int y=0; y<16; y++) {

            int i = (x + y*(16*3)) * 3;  // figure out the memory location

            data[i] = lut_sin(x*255/48+(time)%256 + y*16); //(sin((float)(x+time)/15.0)+1.0)*128 ;   // red
            data[i+1] = lut_sin(x*255/48+(time)%256 + y*16 + 85); //(sin((float)(x+time)/15.0)+1.0)*128 ;   // red
            data[i+2] = lut_sin(x*255/48+(time)%256 + y*16 + 170); //(sin((float)(x+time)/15.0)+1.0)*128 ;   // red
        }
    }

}

// static gradients
void makeFrame3(unsigned char* data) {

    static int time=0;
    time++;

    // override data with a intensity gradient test pattern
    for (int x=0; x<3*16; x++) {
        for (int y=0; y<16; y++) {

            int i = (x + y*(16*3)) * 3;  // figure out the memory location

            data[i] = x*256/48; //(sin((float)(x+time)/15.0)+1.0)*128 ;   // red
            data[i+1] = 0;  // green
            data[i+2] = y*256/16; //(i/3)%256 ; // blue
        }
    }

}


void makeFrame33(unsigned char* data) {

    static int time=0;
    time++;

    for (int x=0; x<3*16; x++) {
        for (int y=0; y<48; y++) {

            int i = (x + y*(16*3)) * 3;  // figure out the memory location

            data[i] = x*256/48; //(sin((float)(x+time)/15.0)+1.0)*128 ;   // red
            data[i+1] = 0;  // green
            data[i+2] = y*256/48; //(i/3)%256 ; // blue
        }
    }
}
 
int main()
{

    // framebuffer on client side
    unsigned char imageSource[256*3*3*3] = { 0 };
    
    // prepare sin lookup table (optional)
    initSinLut(); 

    // start the screen output, which will keep outputting the frames that are in its internal buffer (updated via .transformFrame)
    screen.start();

    while (1) {
        
        makeFrame1(imageSource);  // prepare framebuffer with current frame
        screen.transformFrame(imageSource); // write framebuffer to output framebuffer
        wait_ms(0.5); // slow down the framerate (optional)
    }

}