/* Wav File Support */
/* **************** */

#include "mbed.h"
//#include "misra_types.h"
//#include "Wav_Support_File.h"

#define DEBUG 0

/* Function Prototypes */
unsigned char wave_file_check(unsigned char *wave_array, FILE *open_file);


/* Global Variables */
struct wave_header_construction
                {    char  identification_block[5];
                    unsigned int length_of_file;
                    char  identifier1[5];
                    char  identifier2[5];
                    unsigned int position_of_data;
                    unsigned short format_tag;
                    unsigned short number_of_channels;
                    unsigned int samples_per_second;                    
                    unsigned int bytes_per_second;
                    unsigned short bytes_per_sample;
                    unsigned short bits_per_sample;
                    char  marker[5];
                    unsigned int number_of_bits_in_sample;
                } wave_file_info;





/* Wave File Checker */
unsigned char wave_file_check(unsigned char *wave_array, FILE *open_file)
    {
        unsigned char brk_flag = 0u;
        unsigned char x = 0u;
        unsigned char valid_sample = 0u;
        short ch = 0;
        
        if(DEBUG)  printf("\n\rPrinting out.WAV file header...\n\r");    

        for (x = 0; x < 0x2bu; x++)                                                /* Read the first 0x2b bytes of the file as this is the haeder informtation relating to sample rate etc. */
            {
                ch = fgetc(open_file);                                            /* Get the first byte from the file */
                if (ch == EOF)                                                  /* Check for eof */
                    {
                        if(DEBUG)  printf("   File too short to be a wave file\n\r");    /* If we have less than 0x2b then file is not a wave file. */
                        valid_sample = 0u;
                        brk_flag = 1u;
                    }
                else{
                        wave_array[x] = ch;                                           /* Load data in to header file array */
                    }
                    
                if (brk_flag == 1u) 
                    {
                        break;
                    }
            }
            
        if (brk_flag == 0u)                                                     /* OK we have downloaded the header into an Array. Lets check to see if its a valid file */
            {
                if(DEBUG)  printf("   Identification block (4 ASCII bytes)= ");                                /* First 4 bytes are header block */
                for (x = 0u; x < 4; x++) 
                    {
                        //putc(wave_array[x]);                                                       /* and write them on the screen */
                        wave_file_info.identification_block[x] = wave_array[x];
                    }
                wave_file_info.identification_block[4] = 0;                                            /* add the string terminator on the end */
                if(DEBUG)  printf(" '%s'\n\r", wave_file_info.identification_block);
    
                
                if(DEBUG)  printf("   Length of file (4 bytes) = ");                                        /* Length of file. */
                for (x = 4u; x < 8u; x++) 
                    {
                        if(DEBUG)  printf("%d ",wave_array[x]);
                    }
                wave_file_info.length_of_file =  ( ((unsigned int) wave_array[7] << 24) 
                                                 + ((unsigned int) wave_array[6] << 16) 
                                                 + ((unsigned int) wave_array[5] << 8) 
                                                 + ((unsigned int) wave_array[4]) ); 
                if(DEBUG)  printf(" = %d bytes\n\r", wave_file_info.length_of_file);

            
                if(DEBUG)  printf("   Identifier (4 ASCII bytes) = ");                                        /* indentifier string1 */
                for (x = 8u; x < 12u; x++) 
                    {
                        //putc(wave_array[x]);                                                       /* and write them on the screen */
                        wave_file_info.identifier1[x-8] = wave_array[x];
                    }
                wave_file_info.identification_block[4] = 0;                                            /* add the string terminator on the end */
                if(DEBUG)  printf(" '%s'\n\r", wave_file_info.identifier1);
    
                
                if(DEBUG)  printf("   Identifier (4 ASCII bytes) = ");                                        /* Identifier String 2 */
                for (x = 12; x < 16u; x++) 
                    {
                        //putc(wave_array[x]);                                                       /* and write them on the screen */
                        wave_file_info.identifier2[x-12] = wave_array[x];
                    }
                wave_file_info.identifier2[4] = 0;                                                    /* add the string terminator on the end */
                if(DEBUG)  printf(" '%s'\n\r", wave_file_info.identifier2);
                        

                if(DEBUG)  printf("   Position of data (4 bytes) = ");                                        /* Position of data */
                for (x = 16u; x < 20u; x++) 
                    {
                        if(DEBUG)  printf("%d ",wave_array[x]);
                    }
                wave_file_info.position_of_data =  ( ((unsigned int) wave_array[19] << 24) 
                                                   + ((unsigned int) wave_array[18] << 16) 
                                                   + ((unsigned int) wave_array[17] << 8) 
                                                   + ((unsigned int) wave_array[16]) ); 
                if(DEBUG)  printf(" = %d\n\r", wave_file_info.position_of_data);

            
                if(DEBUG)  printf("   Format Tag - Always 1 for Wave PCM (2 bytes) = ");                    /* format tag */
                for (x = 20u; x < 22u; x++) 
                    {
                        if(DEBUG)  printf("%d ",wave_array[x]);
                    }
                wave_file_info.format_tag = ( ((unsigned int) wave_array[21] << 8) 
                                            + ((unsigned int) wave_array[20]) ); 
                if(DEBUG)  printf(" = %d\n\r", wave_file_info.format_tag);

                        
                if(DEBUG)  printf("   Number of channels (2 bytes) = ");                                    /* Number of channels, mono or steroeo */
                for (x = 22u; x < 24u; x++) 
                    {
                        if(DEBUG)  printf("%d ",wave_array[x]);
                    }
                wave_file_info.number_of_channels = ( ((unsigned int) wave_array[23] << 8) 
                                                    + ((unsigned int) wave_array[22]) ); 
                if(DEBUG)  printf(" = %d channel(s)\n\r", wave_file_info.number_of_channels);

                    
                if(DEBUG)  printf("   Samples per second (4 bytes) = ");                                     /* Samples per second */
                for (x = 24u; x < 28u; x++) 
                    {
                        if(DEBUG)  printf("%d ",wave_array[x]);
                    }
                wave_file_info.samples_per_second =( ((unsigned int) wave_array[27] << 24) 
                                                   + ((unsigned int) wave_array[26] << 16) 
                                                   + ((unsigned int) wave_array[25] << 8) 
                                                   + ((unsigned int) wave_array[24]) ); 
                if(DEBUG)  printf(" = %d samples per sec\n\r", wave_file_info.samples_per_second);

                                
                if(DEBUG)  printf("   Bytes Per Second (4 bytes) = ");                                         /* Bytes per second */
                for (x = 28u; x < 32u; x++) 
                    {
                        if(DEBUG)  printf("%d ",wave_array[x]);
                    }
                wave_file_info.bytes_per_second =  ( ((unsigned int) wave_array[31] << 24) 
                                                   + ((unsigned int) wave_array[30] << 16) 
                                                   + ((unsigned int) wave_array[29] << 8) 
                                                   + ((unsigned int) wave_array[28]) ); 
                if(DEBUG)  printf(" = %d bytes per sec\n\r", wave_file_info.bytes_per_second);

            
                if(DEBUG)  printf("   Bytes Per Sample (2 bytes) = ");                                       /* Bytes per sample */
                for (x = 32u; x < 34u; x++) 
                    {
                        if(DEBUG)  printf("%d ",wave_array[x]);
                    }
                wave_file_info.bytes_per_sample =     ( ((unsigned int) wave_array[33] << 8) 
                                                    + ((unsigned int) wave_array[32]) ); 
                if(DEBUG)  printf(" = %d bytes\n\r", wave_file_info.bytes_per_sample);

                    
                if(DEBUG)  printf("   Bits Per Sample (2 bytes) = ");                                        /* Bits per sample */
                for (x = 34u; x < 36u; x++) 
                    {
                        if(DEBUG)  printf("%d ",wave_array[x]);
                    }
                wave_file_info.bits_per_sample = ( ((unsigned int) wave_array[35] << 8) 
                                                    + ((unsigned int) wave_array[34]) ); 
                if(DEBUG)  printf(" = %d bits\n\r", wave_file_info.bits_per_sample);

                        
                if(DEBUG)  printf("   Marker (4 ASCII bytes) = ");                                            /* Marker */
                for (x = 36u; x < 40u; x++) 
                    {
                        //putc(wave_array[x]);
                        wave_file_info.marker[x-36] = wave_array[x];                        
                    }
                wave_file_info.marker[4] = 0;
                if(DEBUG)  printf(" '%s'\n\r", wave_file_info.marker);
                        

                if(DEBUG)  printf("   The number of bits in the sample (4 bytes) = ");                         /* Number of bits per sample. */
                for (x = 40u; x < 44u; x++) 
                    {
                        if(DEBUG)  printf("%d ",wave_array[x]);
                    }
                wave_file_info.number_of_bits_in_sample =  (  ((unsigned int) wave_array[43] << 24) 
                                                               + ((unsigned int) wave_array[42] << 16) 
                                                               + ((unsigned int) wave_array[41] << 8) 
                                                               + ((unsigned int) wave_array[40]) ); 
                if(DEBUG)  printf(" = %d bits\n\r", wave_file_info.number_of_bits_in_sample);
                    
            
                /* Check for valid Wave file */
                if (((wave_array[0] == 'R') && (wave_array[1] == 'I') && (wave_array[2] == 'F') && (wave_array[3] == 'F'))
                &&  ((wave_array[8] == 'W') && (wave_array[9] == 'A') && (wave_array[0x0a] == 'V') && (wave_array[0x0b] == 'E'))
                && ((wave_array[0x0c] == 'f') && (wave_array[0x0d] == 'm') && (wave_array[0x0e] == 't') && (wave_array[0x0f] == ' '))
                && (wave_array[0x14] == 0x01)) valid_sample = 1u;
                }

        if(DEBUG)  printf("Finished examining the .WAV file header\n\r");
        if (valid_sample == 1)
            {
                if(DEBUG)  printf("Sample is a valid .WAV sample file\n\n\r");
            }
        else{
                if(DEBUG)  printf("Sample is a NOT a valid .WAV sample file\n\n\r");    
            }    

        return valid_sample;
    }
