
#include "timer0.h"

//--------------------------------------------------------
// Construktor initialisiert den Timer
timer0::timer0()
{
    uint8_t i;
    
    // Initialize countdown timers
    for (i=0; i < TIMER0_NUM_COUNTDOWNTIMERS; i++)
      CountDownTimers[i].status = 0xFF;
  
    ticker.attach_us(this, &timer0::func, 1000);
    
    countMillisecond = 0;
}

//--------------------------------------------------------
// Interruptroutine wird jede ms aufgerufen
void timer0::func(void)
{
    uint8_t i;
    
    countMillisecond++;
    
    if(counter != 0) counter--;

    // ----- count down timers in ms -------------------------------------------------
    
    for (i=0; i<TIMER0_NUM_COUNTDOWNTIMERS; i++) 
    {
        if (CountDownTimers[i].status == 1) 
        {      
            if (CountDownTimers[i].count_timer > 0)
                CountDownTimers[i].count_timer -- ;
            if (CountDownTimers[i].count_timer == 0)
                CountDownTimers[i].status = 0;
        }
    }

    //---------------------------------------------------------
    // count down timer für Sekunden
    
    if (countMillisecond >= 1000)
    { 
        countMillisecond = 0;        // ----- count down timers in Sekunden -------------------------------------------------
        
        for (i=0; i<TIMER0_NUM_COUNTDOWNTIMERS; i++) 
        {
            if (CountDownTimers[i].status == 2) 
            {       
                if (CountDownTimers[i].count_timer > 0)
                    CountDownTimers[i].count_timer -- ;
                if (CountDownTimers[i].count_timer == 0)
                    CountDownTimers[i].status = 0;
            }
        }
    }

}

//--------------------------------------------------------
// Abfrage nach freiem Timer
//
// wenn alle Timer belegt sind wird 0xFF zurückgegebne

uint8_t timer0::AllocateCountdownTimer (void)
{
    uint8_t i;
    
    for (i=0; i<TIMER0_NUM_COUNTDOWNTIMERS; i++)
        if (CountDownTimers[i].status == 0xFF)
        {
            CountDownTimers[i].status = 0x00;   // Timer reserviert, nicht gestartet
            // printf_P(PSTR("\rallocate timer [%03d] %d\n"),i,ListPointer);            
            
            return i;
        }

    return 0xFF;
}

//--------------------------------------------------------
// Timer wieder freigeben
void timer0::RemoveCountdownTimer(uint8_t timer)
{
    CountDownTimers[timer].status = 0xFF;
}

//--------------------------------------------------------
// Abfrage ob Timer 0 erreicht hat                  
uint8_t timer0::GetTimerStatus(uint8_t timer)
{
    return CountDownTimers[timer].status;
}

//--------------------------------------------------------
// Abfrage der verbleibenden Zeit               
uint16_t timer0::GetTimerZeit(uint8_t timer)
{
    return CountDownTimers[timer].count_timer;
}

//--------------------------------------------------------
// Timer aktivieren
void timer0::SetCountdownTimer(uint8_t timer, uint8_t status, uint16_t value)
{
    CountDownTimers[timer].count_timer = value;
    CountDownTimers[timer].status = status;
}
